/*
 * Decompiled with CFR 0.152.
 */
package ca.jeffrey.watcard;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class WatSession {
    private CookieStore cookieStore;
    private Cookie verificationCookie;
    private String verificationToken;

    public WatSession() {
        this.initializeSession();
    }

    private void initializeSession() {
        String LOGIN_URL = "https://watcard.uwaterloo.ca/OneWeb/Account/LogOn";
        this.cookieStore = new BasicCookieStore();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore(this.cookieStore).build();
        HttpGet get = new HttpGet("https://watcard.uwaterloo.ca/OneWeb/Account/LogOn");
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            String htmlResponse = new BasicResponseHandler().handleResponse(response);
            Document doc = Jsoup.parse((String)htmlResponse);
            String requestVerificationToken = ((Element)doc.select("input[name=__RequestVerificationToken]").get(0)).val();
            this.setVerificationToken(requestVerificationToken);
            this.setVerificationCookie((Cookie)this.cookieStore.getCookies().get(0));
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public Cookie getVerificationCookie() {
        return this.verificationCookie;
    }

    public void setVerificationCookie(Cookie verification_cookie) {
        this.verificationCookie = verification_cookie;
    }

    public String getVerificationToken() {
        return this.verificationToken;
    }

    public void setVerificationToken(String verification_token) {
        this.verificationToken = verification_token;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookie_store) {
        this.cookieStore = cookie_store;
    }
}

