/*
 * Decompiled with CFR 0.152.
 */
package ca.jeffrey.watcard;

import ca.jeffrey.watcard.WatBalance;
import ca.jeffrey.watcard.WatBalanceType;
import ca.jeffrey.watcard.WatSession;
import ca.jeffrey.watcard.WatTransaction;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class WatAccount {
    private final int BALANCE_TYPES = 12;
    private WatSession session;
    private String account;
    private char[] password;
    private List<WatBalance> balances;
    private String name;
    private String birthDate;
    private String maritalStatus;
    private String sex;
    private String email;
    private String phone;
    private String mobile;
    private String address;

    public WatAccount(WatSession session, String account, String password) {
        this.session = session;
        this.account = account;
        this.password = password.toCharArray();
        this.balances = new ArrayList<WatBalance>();
        this.address = "";
        this.mobile = "";
        this.phone = "";
        this.email = "";
        this.sex = "";
        this.maritalStatus = "";
        this.birthDate = "";
        this.name = "";
    }

    public WatAccount(String account, String password) {
        this.session = new WatSession();
        this.account = account;
        this.password = password.toCharArray();
        this.balances = new ArrayList<WatBalance>();
        this.address = "";
        this.mobile = "";
        this.phone = "";
        this.email = "";
        this.sex = "";
        this.maritalStatus = "";
        this.birthDate = "";
        this.name = "";
    }

    public void newSession() {
        this.session = new WatSession();
    }

    public int login() {
        String LOGIN_URL = "https://watcard.uwaterloo.ca/OneWeb/Account/LogOn";
        int code = -1;
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore(this.session.getCookieStore()).build();
        HttpPost post = new HttpPost("https://watcard.uwaterloo.ca/OneWeb/Account/LogOn");
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        urlParameters.add(new BasicNameValuePair("__RequestVerificationToken", this.session.getVerificationToken()));
        urlParameters.add(new BasicNameValuePair("AccountMode", "0"));
        urlParameters.add(new BasicNameValuePair("Account", this.account));
        urlParameters.add(new BasicNameValuePair("Password", new String(this.password)));
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
            HttpResponse response = client.execute((HttpUriRequest)post);
            code = response.getStatusLine().getStatusCode();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return code;
    }

    public void loadPersonalInfo() {
        String BALANCE_URL = "https://watcard.uwaterloo.ca/OneWeb/Account/Personal";
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore(this.session.getCookieStore()).build();
        HttpGet get = new HttpGet("https://watcard.uwaterloo.ca/OneWeb/Account/Personal");
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            String htmlResponse = new BasicResponseHandler().handleResponse(response);
            Document doc = Jsoup.parse((String)htmlResponse);
            Elements info = doc.getElementsByClass("ow-info-container").first().select("span.ow-value");
            this.name = ((Element)info.get(0)).text().replaceAll("\\.", "");
            this.birthDate = ((Element)info.get(2)).text();
            this.maritalStatus = ((Element)info.get(3)).text();
            this.sex = ((Element)info.get(4)).text();
            this.email = ((Element)info.get(5)).text();
            this.phone = ((Element)info.get(6)).text().replaceAll("[-().\\s]", "");
            this.mobile = ((Element)info.get(7)).text().replaceAll("[-().\\s]", "");
            this.address = ((Element)info.get(8)).text();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public void displayPersonalInfo() {
        System.out.printf("Name: %s%nBirth date: %s%nMarital Status: %s%nSex: %s%nEmail: %s%nPhone: %s%nMobile: %s%nAddress: %s%n", this.name, this.birthDate, this.maritalStatus, this.sex, this.email, this.phone, this.mobile, this.address);
    }

    public void loadBalances() {
        String BALANCE_URL = "https://watcard.uwaterloo.ca/OneWeb/Financial/Balances";
        this.balances = new ArrayList<WatBalance>();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore(this.session.getCookieStore()).build();
        HttpGet get = new HttpGet("https://watcard.uwaterloo.ca/OneWeb/Financial/Balances");
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            String htmlResponse = new BasicResponseHandler().handleResponse(response);
            Document doc = Jsoup.parse((String)htmlResponse);
            Elements accounts = doc.getElementsByClass("table table-striped ow-table-responsive").first().select("tbody").first().select("tr");
            for (Element balance : accounts) {
                Elements info = balance.select("td");
                String id = ((Element)info.get(0)).text();
                String name = ((Element)info.get(1)).text();
                double limit = Double.parseDouble(((Element)info.get(2)).text().replace("$", ""));
                double value = Double.parseDouble(((Element)info.get(3)).text().replace("$", ""));
                this.balances.add(new WatBalance(id, name, limit, value));
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public void displayBalances() {
        for (WatBalance b : this.balances) {
            System.out.println(b);
        }
    }

    public List<WatBalance> getBalances() {
        return this.balances;
    }

    public WatBalance getWatBalance(WatBalanceType type) {
        WatBalance balance = null;
        if (this.balances.size() == 12) {
            switch (type) {
                case VILLAGE_MEAL: {
                    balance = this.balances.get(0);
                    break;
                }
                case BEST_BUY_MEAL: {
                    balance = this.balances.get(1);
                    break;
                }
                case FOOD_PLAN: {
                    balance = this.balances.get(2);
                    break;
                }
                case FLEX1: {
                    balance = this.balances.get(3);
                    break;
                }
                case FLEX2: {
                    balance = this.balances.get(4);
                    break;
                }
                case FLEX3: {
                    balance = this.balances.get(5);
                    break;
                }
                case TRANSFER: {
                    balance = this.balances.get(6);
                    break;
                }
                case DON_MEAL: {
                    balance = this.balances.get(7);
                    break;
                }
                case DON_FLEX: {
                    balance = this.balances.get(8);
                    break;
                }
                case REWARDS: {
                    balance = this.balances.get(9);
                    break;
                }
                case DEPT_CHARGE: {
                    balance = this.balances.get(10);
                    break;
                }
                case OVERDRAFT: {
                    balance = this.balances.get(11);
                }
            }
        }
        return balance;
    }

    public double getWatBalanceValue(WatBalanceType type) {
        WatBalance balance = this.getWatBalance(type);
        if (balance == null) {
            return 0.0;
        }
        return balance.getValue();
    }

    public double getFlexBalance() {
        double balance = 0.0;
        if (this.balances.size() == 12) {
            balance = this.getWatBalance(WatBalanceType.FLEX1).getValue() + this.getWatBalance(WatBalanceType.FLEX2).getValue() + this.getWatBalance(WatBalanceType.FLEX3).getValue();
        }
        return balance;
    }

    public double getMealBalance() {
        double balance = 0.0;
        if (this.balances.size() == 12) {
            balance = this.getWatBalance(WatBalanceType.VILLAGE_MEAL).getValue() + this.getWatBalance(WatBalanceType.BEST_BUY_MEAL).getValue() + this.getWatBalance(WatBalanceType.FOOD_PLAN).getValue();
        }
        return balance;
    }

    public List<WatTransaction> getTransactions(String url) {
        DateTimeFormatter RESPONSE_FORMAT = DateTimeFormatter.ofPattern("MM/dd/yyyy h:mm:ss a");
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore(this.session.getCookieStore()).build();
        HttpGet get = new HttpGet(url);
        ArrayList<WatTransaction> transactions = new ArrayList<WatTransaction>();
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            String htmlResponse = new BasicResponseHandler().handleResponse(response);
            if (!htmlResponse.contains("No transactions found!")) {
                Document doc = Jsoup.parse((String)htmlResponse);
                Elements row = doc.getElementsByClass("table table-striped ow-table-responsive").first().select("tbody").first().select("tr");
                for (Element transaction : row) {
                    Elements data = transaction.select("td");
                    LocalDateTime dateTime = LocalDateTime.parse(((Element)data.get(0)).text(), RESPONSE_FORMAT);
                    double amount = Double.valueOf(((Element)data.get(1)).text().replace("$", ""));
                    String account = ((Element)data.get(2)).text();
                    int unit = Integer.valueOf(((Element)data.get(3)).text());
                    String type = ((Element)data.get(4)).text();
                    String terminal = ((Element)data.get(5)).text();
                    transactions.add(new WatTransaction(dateTime, amount, account, unit, type, terminal));
                }
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return transactions;
    }

    public List<WatTransaction> getTransactions(LocalDateTime begin) {
        String formattedBegin = WatTransaction.DATE_FORMAT.format(begin);
        String formattedToday = WatTransaction.DATE_FORMAT.format(LocalDateTime.now());
        String url = "https://watcard.uwaterloo.ca/OneWeb/Financial/TransactionsPass" + String.format("?dateFrom=%s&dateTo=%s&returnRows=0", formattedBegin, formattedToday);
        return this.getTransactions(url);
    }

    public List<WatTransaction> getTransactions(LocalDateTime begin, int quantity) {
        String formattedBegin = WatTransaction.DATE_FORMAT.format(begin);
        String formattedToday = WatTransaction.DATE_FORMAT.format(LocalDateTime.now());
        String url = "https://watcard.uwaterloo.ca/OneWeb/Financial/TransactionsPass" + String.format("?dateFrom=%s&dateTo=%s&returnRows=%d", formattedBegin, formattedToday, quantity);
        return this.getTransactions(url);
    }

    public List<WatTransaction> getTransactions(LocalDateTime begin, LocalDateTime end) {
        String formattedBegin = WatTransaction.DATE_FORMAT.format(begin);
        String formattedEnd = WatTransaction.DATE_FORMAT.format(end);
        String url = "https://watcard.uwaterloo.ca/OneWeb/Financial/TransactionsPass" + String.format("?dateFrom=%s&dateTo=%s&returnRows=0", formattedBegin, formattedEnd);
        return this.getTransactions(url);
    }

    public List<WatTransaction> getTransactions(LocalDateTime begin, LocalDateTime end, int quantity) {
        String formattedBegin = WatTransaction.DATE_FORMAT.format(begin);
        String formattedEnd = WatTransaction.DATE_FORMAT.format(end);
        String url = "https://watcard.uwaterloo.ca/OneWeb/Financial/TransactionsPass" + String.format("?dateFrom=%s&dateTo=%s&returnRows=%d", formattedBegin, formattedEnd, quantity);
        return this.getTransactions(url);
    }

    public List<WatTransaction> getLastDaysTransactions(int days, boolean exact) {
        String formattedEnd;
        String formattedBegin;
        if (exact) {
            formattedBegin = WatTransaction.DATE_FORMAT.format(LocalDateTime.now().minusDays(days));
            formattedEnd = WatTransaction.DATE_FORMAT.format(LocalDateTime.now());
        } else {
            formattedBegin = WatTransaction.DATE_FORMAT.format(LocalDateTime.now().minusDays(days).truncatedTo(ChronoUnit.DAYS));
            formattedEnd = WatTransaction.DATE_FORMAT.format(LocalDateTime.now());
        }
        String url = "https://watcard.uwaterloo.ca/OneWeb/Financial/TransactionsPass" + String.format("?dateFrom=%s&dateTo=%s&returnRows=0", formattedBegin, formattedEnd);
        return this.getTransactions(url);
    }

    public WatSession getSession() {
        return this.session;
    }

    public void setSession(WatSession session) {
        this.session = session;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setBalances(List<WatBalance> balances) {
        this.balances = balances;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(String birthDate) {
        this.birthDate = birthDate;
    }

    public String getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public String getSex() {
        return this.sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}

