/*
 * Decompiled with CFR 0.152.
 */
package ca.jeffrey.watcard;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;

public class WatTransaction
implements Serializable {
    protected static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern((String)"yyyy/MM/dd+HH:mm:ss");
    protected static final String BASE_URL = "https://watcard.uwaterloo.ca/OneWeb/Financial/TransactionsPass";
    private LocalDateTime dateTime;
    private float amount;
    private String account;
    private int unit;
    private String type;
    private String terminal;
    private boolean flex;

    public WatTransaction(LocalDateTime dateTime, float amount, String account, int unit, String type, String terminal) {
        this.dateTime = dateTime;
        this.amount = amount;
        this.account = account;
        this.unit = unit;
        this.type = type;
        this.terminal = terminal;
        this.flex = !terminal.contains("WAT-FS");
    }

    public String toString() {
        return String.format("Date: %s%nAmount: $%.2f%nAccount: %s%nUnit: %d%nType: %s%nTerminal: %s", this.dateTime.toString(), Float.valueOf(this.amount), this.account, this.unit, this.type, this.terminal);
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    public String getTimeString() {
        DateTimeFormatter myFormat = DateTimeFormatter.ofPattern((String)"dd MMM 'at' h:mm a");
        return myFormat.format((TemporalAccessor)this.dateTime);
    }

    public boolean isFlex() {
        return this.flex;
    }

    public void setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public float getAmount() {
        return this.amount;
    }

    public String getAmountString() {
        return NumberFormat.getCurrencyInstance(Locale.CANADA).format(this.amount);
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public int getUnit() {
        return this.unit;
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTerminal() {
        return this.terminal;
    }

    public String getCleanTerminal() {
        return this.terminal.replace("WAT-FS-", "").split(" : ")[1];
    }

    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }
}

