/*
 * Decompiled with CFR 0.152.
 */
package ca.jeffrey.watcard;

import ca.jeffrey.watcard.WatBalance;
import ca.jeffrey.watcard.WatBalanceType;
import ca.jeffrey.watcard.WatSession;
import ca.jeffrey.watcard.WatTransaction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalUnit;

public class WatAccount {
    private final int BALANCE_TYPES = 12;
    private WatSession session;
    private String account;
    private char[] password;
    private List<WatBalance> balances;
    private float total;
    private String name;
    private String birthDate;
    private String maritalStatus;
    private String sex;
    private String email;
    private String phone;
    private String mobile;
    private String address;
    private String photo;

    public WatAccount(WatSession session, String account, String password) {
        this.session = session;
        this.account = account;
        this.password = password.toCharArray();
        this.balances = new ArrayList<WatBalance>();
        this.total = 0.0f;
        this.photo = "";
        this.address = "";
        this.mobile = "";
        this.phone = "";
        this.email = "";
        this.sex = "";
        this.maritalStatus = "";
        this.birthDate = "";
        this.name = "";
    }

    public WatAccount(String account, String password) {
        this.session = new WatSession();
        this.account = account;
        this.password = password.toCharArray();
        this.balances = new ArrayList<WatBalance>();
        this.total = 0.0f;
        this.photo = "";
        this.address = "";
        this.mobile = "";
        this.phone = "";
        this.email = "";
        this.sex = "";
        this.maritalStatus = "";
        this.birthDate = "";
        this.name = "";
    }

    public void newSession() {
        this.session = new WatSession();
    }

    public int login() {
        String LOGIN_URL = "https://watcard.uwaterloo.ca/OneWeb/Account/LogOn";
        int code = -1;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("__RequestVerificationToken", this.session.getVerificationToken());
        params.put("AccountMode", "0");
        params.put("Account", this.account);
        params.put("Password", new String(this.password));
        try {
            URL url = new URL("https://watcard.uwaterloo.ca/OneWeb/Account/LogOn");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(15000);
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            StringBuilder postData = new StringBuilder();
            for (Map.Entry param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode((String)param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            byte[] postDataBytes = postData.toString().getBytes("UTF-8");
            connection.getOutputStream().write(postDataBytes);
            code = connection.getResponseCode();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return code;
    }

    public void loadPersonalInfo() {
        String BASE_URL = "https://watcard.uwaterloo.ca";
        String PERSONAL_URL = "https://watcard.uwaterloo.ca/OneWeb/Account/Personal";
        try {
            URL url = new URL("https://watcard.uwaterloo.ca/OneWeb/Account/Personal");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(15000);
            connection.setRequestMethod("GET");
            connection.getContent();
            InputStream inputStream = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
            String line = "";
            StringBuffer buffer = new StringBuffer("");
            while ((line = rd.readLine()) != null) {
                buffer.append(line);
            }
            String htmlResponse = buffer.toString();
            Document doc = Jsoup.parse((String)htmlResponse);
            Elements info = doc.getElementsByClass("ow-info-container").first().select("span.ow-value");
            this.name = ((Element)info.get(0)).text().replaceAll("\\.", "");
            this.birthDate = ((Element)info.get(2)).text();
            this.maritalStatus = ((Element)info.get(3)).text();
            this.sex = ((Element)info.get(4)).text();
            this.email = ((Element)info.get(5)).text();
            this.phone = ((Element)info.get(6)).text().replaceAll("[-().\\s]", "");
            this.mobile = ((Element)info.get(7)).text().replaceAll("[-().\\s]", "");
            this.address = ((Element)info.get(8)).text();
            Element jpg = doc.select(".ow-id-container.hidden-xs").first().select("[data-original]").first();
            this.photo = "https://watcard.uwaterloo.ca" + jpg.attr("data-original");
            if (this.photo.equals("https://watcard.uwaterloo.ca")) {
                this.photo = "";
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public void displayPersonalInfo() {
        System.out.printf("Name: %s%nBirth date: %s%nMarital Status: %s%nSex: %s%nEmail: %s%nPhone: %s%nMobile: %s%nAddress: %s%n", this.name, this.birthDate, this.maritalStatus, this.sex, this.email, this.phone, this.mobile, this.address);
    }

    public void loadBalances() {
        String BALANCE_URL = "https://watcard.uwaterloo.ca/OneWeb/Financial/Balances";
        this.balances = new ArrayList<WatBalance>();
        CookieManager cookieManager = this.session.getCookieManager();
        CookieHandler.setDefault(cookieManager);
        try {
            URL url = new URL("https://watcard.uwaterloo.ca/OneWeb/Financial/Balances");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(15000);
            connection.setRequestMethod("GET");
            connection.getContent();
            InputStream inputStream = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
            String line = "";
            StringBuffer buffer = new StringBuffer("");
            while ((line = rd.readLine()) != null) {
                buffer.append(line + "\n");
            }
            String htmlResponse = buffer.toString();
            Document doc = Jsoup.parse((String)htmlResponse);
            Elements accounts = doc.getElementsByClass("table table-striped ow-table-responsive").first().select("tbody").first().select("tr");
            for (Element balance : accounts) {
                Elements info = balance.select("td");
                String id = ((Element)info.get(0)).text();
                String name = ((Element)info.get(1)).text();
                float limit = Float.parseFloat(((Element)info.get(2)).text().replace("$", ""));
                float value = Float.parseFloat(((Element)info.get(3)).text().replace("$", ""));
                this.balances.add(new WatBalance(id, name, limit, value));
            }
            String totalString = doc.select("span.pull-right").text().replace("Total: $", "");
            this.total = Float.valueOf(totalString).floatValue();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public void displayBalances() {
        for (WatBalance b : this.balances) {
            System.out.println(b);
        }
    }

    public List<WatBalance> getBalances() {
        return this.balances;
    }

    public WatBalance getWatBalance(WatBalanceType type) {
        WatBalance balance = null;
        if (this.balances.size() == 12) {
            switch (type) {
                case VILLAGE_MEAL: {
                    balance = this.balances.get(0);
                    break;
                }
                case BEST_BUY_MEAL: {
                    balance = this.balances.get(1);
                    break;
                }
                case FOOD_PLAN: {
                    balance = this.balances.get(2);
                    break;
                }
                case FLEX1: {
                    balance = this.balances.get(3);
                    break;
                }
                case FLEX2: {
                    balance = this.balances.get(4);
                    break;
                }
                case FLEX3: {
                    balance = this.balances.get(5);
                    break;
                }
                case TRANSFER: {
                    balance = this.balances.get(6);
                    break;
                }
                case DON_MEAL: {
                    balance = this.balances.get(7);
                    break;
                }
                case DON_FLEX: {
                    balance = this.balances.get(8);
                    break;
                }
                case REWARDS: {
                    balance = this.balances.get(9);
                    break;
                }
                case DEPT_CHARGE: {
                    balance = this.balances.get(10);
                    break;
                }
                case OVERDRAFT: {
                    balance = this.balances.get(11);
                }
            }
        }
        return balance;
    }

    public float getWatBalanceValue(WatBalanceType type) {
        WatBalance balance = this.getWatBalance(type);
        if (balance == null) {
            return 0.0f;
        }
        return balance.getValue();
    }

    public float getFlexBalance() {
        float balance = 0.0f;
        if (this.balances.size() == 12) {
            balance = this.getWatBalance(WatBalanceType.FLEX1).getValue() + this.getWatBalance(WatBalanceType.FLEX2).getValue() + this.getWatBalance(WatBalanceType.FLEX3).getValue();
        }
        return balance;
    }

    public float getMealBalance() {
        float balance = 0.0f;
        if (this.balances.size() == 12) {
            balance = this.getWatBalance(WatBalanceType.VILLAGE_MEAL).getValue() + this.getWatBalance(WatBalanceType.BEST_BUY_MEAL).getValue() + this.getWatBalance(WatBalanceType.FOOD_PLAN).getValue();
        }
        return balance;
    }

    public float getOtherBalance() {
        float balance = 0.0f;
        if (this.balances.size() == 12) {
            balance = this.getWatBalance(WatBalanceType.TRANSFER).getValue() + this.getWatBalance(WatBalanceType.DON_MEAL).getValue() + this.getWatBalance(WatBalanceType.DON_FLEX).getValue() + this.getWatBalance(WatBalanceType.REWARDS).getValue() + this.getWatBalance(WatBalanceType.DEPT_CHARGE).getValue() + this.getWatBalance(WatBalanceType.OVERDRAFT).getValue();
        }
        return balance;
    }

    public List<WatTransaction> getTransactions(String url) {
        DateTimeFormatter RESPONSE_FORMAT = DateTimeFormatter.ofPattern((String)"MM/dd/yyyy h:mm:ss a");
        ArrayList<WatTransaction> transactions = new ArrayList<WatTransaction>();
        try {
            URL url_ = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)url_.openConnection();
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(15000);
            connection.setRequestMethod("GET");
            connection.getContent();
            InputStream inputStream = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
            String line = "";
            StringBuffer buffer = new StringBuffer("");
            while ((line = rd.readLine()) != null) {
                buffer.append(line);
            }
            String htmlResponse = buffer.toString();
            if (!htmlResponse.contains("No transactions found!")) {
                Document doc = Jsoup.parse((String)htmlResponse);
                Elements row = doc.getElementsByClass("table table-striped ow-table-responsive").first().select("tbody").first().select("tr");
                for (Element transaction : row) {
                    Elements data = transaction.select("td");
                    LocalDateTime dateTime = LocalDateTime.parse((CharSequence)((Element)data.get(0)).text(), (DateTimeFormatter)RESPONSE_FORMAT);
                    float amount = Float.valueOf(((Element)data.get(1)).text().replace("$", "")).floatValue();
                    String account = ((Element)data.get(2)).text();
                    int unit = Integer.valueOf(((Element)data.get(3)).text());
                    String type = ((Element)data.get(4)).text();
                    String terminal = ((Element)data.get(5)).text();
                    transactions.add(new WatTransaction(dateTime, amount, account, unit, type, terminal));
                }
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return transactions;
    }

    public List<WatTransaction> getTransactions(LocalDateTime begin) {
        String formattedBegin = WatTransaction.DATE_FORMAT.format((TemporalAccessor)begin);
        String formattedToday = WatTransaction.DATE_FORMAT.format((TemporalAccessor)LocalDateTime.now());
        String url = "https://watcard.uwaterloo.ca/OneWeb/Financial/TransactionsPass" + String.format("?dateFrom=%s&dateTo=%s&returnRows=0", formattedBegin, formattedToday);
        return this.getTransactions(url);
    }

    public List<WatTransaction> getTransactions(LocalDateTime begin, int quantity) {
        String formattedBegin = WatTransaction.DATE_FORMAT.format((TemporalAccessor)begin);
        String formattedToday = WatTransaction.DATE_FORMAT.format((TemporalAccessor)LocalDateTime.now());
        String url = "https://watcard.uwaterloo.ca/OneWeb/Financial/TransactionsPass" + String.format("?dateFrom=%s&dateTo=%s&returnRows=%d", formattedBegin, formattedToday, quantity);
        return this.getTransactions(url);
    }

    public List<WatTransaction> getTransactions(LocalDateTime begin, LocalDateTime end) {
        String formattedBegin = WatTransaction.DATE_FORMAT.format((TemporalAccessor)begin);
        String formattedEnd = WatTransaction.DATE_FORMAT.format((TemporalAccessor)end);
        String url = "https://watcard.uwaterloo.ca/OneWeb/Financial/TransactionsPass" + String.format("?dateFrom=%s&dateTo=%s&returnRows=0", formattedBegin, formattedEnd);
        return this.getTransactions(url);
    }

    public List<WatTransaction> getTransactions(LocalDateTime begin, LocalDateTime end, int quantity) {
        String formattedBegin = WatTransaction.DATE_FORMAT.format((TemporalAccessor)begin);
        String formattedEnd = WatTransaction.DATE_FORMAT.format((TemporalAccessor)end);
        String url = "https://watcard.uwaterloo.ca/OneWeb/Financial/TransactionsPass" + String.format("?dateFrom=%s&dateTo=%s&returnRows=%d", formattedBegin, formattedEnd, quantity);
        return this.getTransactions(url);
    }

    public List<WatTransaction> getLastDaysTransactions(int days, boolean exact) {
        String formattedEnd;
        String formattedBegin;
        if (exact) {
            formattedBegin = WatTransaction.DATE_FORMAT.format((TemporalAccessor)LocalDateTime.now().minusDays((long)days));
            formattedEnd = WatTransaction.DATE_FORMAT.format((TemporalAccessor)LocalDateTime.now());
        } else {
            formattedBegin = WatTransaction.DATE_FORMAT.format((TemporalAccessor)LocalDateTime.now().minusDays((long)days).truncatedTo((TemporalUnit)ChronoUnit.DAYS));
            formattedEnd = WatTransaction.DATE_FORMAT.format((TemporalAccessor)LocalDateTime.now());
        }
        String url = "https://watcard.uwaterloo.ca/OneWeb/Financial/TransactionsPass" + String.format("?dateFrom=%s&dateTo=%s&returnRows=0", formattedBegin, formattedEnd);
        return this.getTransactions(url);
    }

    public WatSession getSession() {
        return this.session;
    }

    public void setSession(WatSession session) {
        this.session = session;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setBalances(List<WatBalance> balances) {
        this.balances = balances;
    }

    public float getTotalBalance() {
        return this.total;
    }

    public void setTotalBalance(float total) {
        this.total = total;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(String birthDate) {
        this.birthDate = birthDate;
    }

    public String getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public String getSex() {
        return this.sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPhoto() {
        return this.photo;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }
}

