/*
 * Decompiled with CFR 0.152.
 */
package ca.jeb.protobuf.internal;

import ca.jeb.common.infra.JReflectionUtils;
import ca.jeb.common.infra.JStringUtils;
import ca.jeb.protobuf.ProtobufAttribute;
import ca.jeb.protobuf.ProtobufEntity;
import com.google.protobuf.GeneratedMessage;
import java.lang.reflect.Field;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class ProtobufSerializerUtils {
    private static final Map<String, Map<Field, ProtobufAttribute>> CLASS_TO_FIELD_MAP_CACHE = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<String, Map<String, String>> CLASS_TO_FIELD_SETTERS_MAP_CACHE = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<String, Map<String, String>> CLASS_TO_FIELD_GETTERS_MAP_CACHE = Collections.synchronizedMap(new WeakHashMap());

    public static final Class<? extends Object> getProtobufClass(Object value, Class<? extends Object> protobufClass) {
        if (value instanceof Integer) {
            return Integer.TYPE;
        }
        if (value instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (value instanceof Double) {
            return Double.TYPE;
        }
        if (value instanceof Long || value instanceof Date) {
            return Long.TYPE;
        }
        if (value instanceof List) {
            return Iterable.class;
        }
        return protobufClass;
    }

    public static final ProtobufEntity getProtobufEntity(Class<?> clazz) {
        ProtobufEntity protoBufEntity = clazz.getAnnotation(ProtobufEntity.class);
        if (protoBufEntity != null) {
            return protoBufEntity;
        }
        return null;
    }

    public static final boolean isProtbufEntity(Object object) {
        return ProtobufSerializerUtils.isProtbufEntity(object.getClass());
    }

    public static final boolean isProtbufEntity(Class<?> clazz) {
        ProtobufEntity protoBufEntity = ProtobufSerializerUtils.getProtobufEntity(clazz);
        return protoBufEntity != null;
    }

    public static final Class<? extends GeneratedMessage> getProtobufClassFromPojoAnno(Class<?> clazz) {
        ProtobufEntity annotation = ProtobufSerializerUtils.getProtobufEntity(clazz);
        Class<? extends GeneratedMessage> gpbClazz = annotation.value();
        if (gpbClazz == null) {
            return null;
        }
        return gpbClazz;
    }

    public static final Map<Field, ProtobufAttribute> getAllProtbufFields(Class<? extends Object> fromClazz) {
        Map<Field, ProtobufAttribute> protoBufFields = CLASS_TO_FIELD_MAP_CACHE.get(fromClazz.getCanonicalName());
        if (protoBufFields != null) {
            return protoBufFields;
        }
        protoBufFields = new HashMap<Field, ProtobufAttribute>();
        List fields = JReflectionUtils.getAllFields(new ArrayList(), fromClazz);
        for (Field field : fields) {
            ProtobufAttribute annotation = field.getAnnotation(ProtobufAttribute.class);
            if (annotation == null) continue;
            ProtobufAttribute gpbAnnotation = annotation;
            protoBufFields.put(field, gpbAnnotation);
        }
        CLASS_TO_FIELD_MAP_CACHE.put(fromClazz.getCanonicalName(), protoBufFields);
        return protoBufFields;
    }

    public static final String getProtobufSetter(ProtobufAttribute protobufAttribute, Field field, Object fieldValue) {
        String configedSetter;
        String fieldName = field.getName();
        String upperClassName = field.getDeclaringClass().getCanonicalName();
        Map<String, String> map = CLASS_TO_FIELD_SETTERS_MAP_CACHE.get(upperClassName);
        if (map != null) {
            if (!map.isEmpty() && map.containsKey(fieldName)) {
                return map.get(fieldName);
            }
        } else {
            map = new ConcurrentHashMap<String, String>();
        }
        String setter = "set" + JStringUtils.upperCaseFirst((String)fieldName);
        if (fieldValue instanceof Collection) {
            setter = "addAll" + JStringUtils.upperCaseFirst((String)fieldName);
        }
        if (!(configedSetter = protobufAttribute.protobufSetter()).equals("")) {
            setter = configedSetter;
        }
        map.put(fieldName, setter);
        CLASS_TO_FIELD_SETTERS_MAP_CACHE.put(upperClassName, map);
        return setter;
    }

    public static final String getProtobufGetter(ProtobufAttribute protobufAttribute, Field field) {
        String fieldName = field.getName();
        String upperClassName = field.getDeclaringClass().getCanonicalName();
        Map<String, String> map = CLASS_TO_FIELD_GETTERS_MAP_CACHE.get(upperClassName);
        if (map != null) {
            if (!map.isEmpty() && map.containsKey(fieldName)) {
                return map.get(fieldName);
            }
        } else {
            map = new ConcurrentHashMap<String, String>();
        }
        String upperCaseFirstFieldName = JStringUtils.upperCaseFirst((String)field.getName());
        String getter = "get" + upperCaseFirstFieldName;
        if (Collection.class.isAssignableFrom(field.getType())) {
            getter = getter + "List";
        }
        if (!protobufAttribute.protobufGetter().isEmpty()) {
            return protobufAttribute.protobufGetter();
        }
        map.put(fieldName, getter);
        CLASS_TO_FIELD_GETTERS_MAP_CACHE.put(upperClassName, map);
        return getter;
    }

    public static final String getPojoSetter(ProtobufAttribute protobufAttribute, Field field) {
        String fieldName = field.getName();
        String upperClassName = field.getDeclaringClass().getCanonicalName();
        Map<String, String> map = CLASS_TO_FIELD_SETTERS_MAP_CACHE.get(upperClassName);
        if (map != null) {
            if (!map.isEmpty() && map.containsKey(fieldName)) {
                return map.get(fieldName);
            }
        } else {
            map = new ConcurrentHashMap<String, String>();
        }
        String upperCaseFirstFieldName = JStringUtils.upperCaseFirst((String)field.getName());
        String setter = "set" + upperCaseFirstFieldName;
        if (!protobufAttribute.pojoSetter().isEmpty()) {
            return protobufAttribute.pojoSetter();
        }
        map.put(fieldName, setter);
        CLASS_TO_FIELD_SETTERS_MAP_CACHE.put(upperClassName, map);
        return setter;
    }
}

