/*
 * Decompiled with CFR 0.152.
 */
package ca.jeb.protobuf;

import ca.jeb.common.infra.JException;
import ca.jeb.common.infra.JReflectionUtils;
import ca.jeb.common.infra.JStringUtils;
import ca.jeb.protobuf.IProtobufConverter;
import ca.jeb.protobuf.IProtobufSerializer;
import ca.jeb.protobuf.ProtobufAnnotationException;
import ca.jeb.protobuf.ProtobufAttribute;
import ca.jeb.protobuf.ProtobufEntity;
import ca.jeb.protobuf.ProtobufException;
import ca.jeb.protobuf.converter.NullConverter;
import ca.jeb.protobuf.internal.ProtobufSerializerUtils;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufSerializer
implements IProtobufSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtobufSerializer.class);

    @Override
    public Message toProtobuf(Object pojo) throws ProtobufException {
        try {
            Class<?> fromClazz = pojo.getClass();
            Class<? extends GeneratedMessage> protoClazz = ProtobufSerializerUtils.getProtobufClassFromPojoAnno(fromClazz);
            if (protoClazz == null) {
                throw new ProtobufAnnotationException("Doesn't seem like " + fromClazz + " is ProtobufEntity");
            }
            Map<Field, ProtobufAttribute> protoBufFields = ProtobufSerializerUtils.getAllProtbufFields(fromClazz);
            if (protoBufFields.isEmpty()) {
                return null;
            }
            Method newBuilderMethod = protoClazz.getMethod("newBuilder", new Class[0]);
            Message.Builder protoObjBuilder = (Message.Builder)newBuilderMethod.invoke(null, new Object[0]);
            for (Map.Entry<Field, ProtobufAttribute> entry : protoBufFields.entrySet()) {
                Field field = entry.getKey();
                ProtobufAttribute gpbAnnotation = entry.getValue();
                String fieldName = field.getName();
                Object value = ProtobufSerializer.getPojoFieldValue(pojo, gpbAnnotation, field);
                if (value == null || (value = ProtobufSerializer.serializeToProtobufEntity(value)) instanceof Collection && ((Collection)(value = ProtobufSerializer.convertCollectionToProtobufs((Collection)value))).isEmpty()) continue;
                String setter = ProtobufSerializerUtils.getProtobufSetter(gpbAnnotation, field, value);
                ProtobufSerializer.setProtobufFieldValue(gpbAnnotation, protoObjBuilder, setter, value);
            }
            return protoObjBuilder.build();
        }
        catch (Exception e) {
            throw new ProtobufException("Could not generate Protobuf object for " + pojo.getClass() + ": " + e, e);
        }
    }

    public Object fromProtobuf(Message protobuf, Class<?> pojoClazz) throws ProtobufException {
        try {
            Class<? extends GeneratedMessage> protoClazz = ProtobufSerializerUtils.getProtobufClassFromPojoAnno(pojoClazz);
            if (protoClazz == null) {
                throw new ProtobufAnnotationException("Doesn't seem like " + pojoClazz + " is ProtobufEntity");
            }
            Map<Field, ProtobufAttribute> protobufFields = ProtobufSerializerUtils.getAllProtbufFields(pojoClazz);
            if (protobufFields.isEmpty()) {
                throw new ProtobufException("No protoBuf fields have been annotated on the class " + pojoClazz + ", thus cannot continue.");
            }
            Object pojo = pojoClazz.newInstance();
            for (Map.Entry<Field, ProtobufAttribute> entry : protobufFields.entrySet()) {
                Field field = entry.getKey();
                ProtobufAttribute protobufAttribute = entry.getValue();
                String setter = ProtobufSerializerUtils.getPojoSetter(protobufAttribute, field);
                Object protobufValue = ProtobufSerializer.getProtobufFieldValue(protobuf, protobufAttribute, field);
                if (protobufValue == null) continue;
                ProtobufSerializer.setPojoFieldValue(pojo, setter, protobufValue, protobufAttribute);
            }
            return pojo;
        }
        catch (Exception e) {
            throw new ProtobufException("Could not generate POJO of type " + pojoClazz + " from Protobuf object " + protobuf.getClass() + ": " + e, e);
        }
    }

    private static final Object getPojoFieldValue(Object pojo, ProtobufAttribute protobufAttribute, Field field) throws ProtobufAnnotationException {
        String getter = protobufAttribute.pojoGetter();
        Object value = null;
        if (!getter.isEmpty()) {
            try {
                return JReflectionUtils.runMethod((Object)pojo, (String)getter, (Object[])new Object[0]);
            }
            catch (Exception e) {
                throw new ProtobufAnnotationException("Could not get a value for field " + field.getName() + " using configured getter of " + getter, e);
            }
        }
        try {
            value = JReflectionUtils.runGetter((Object)pojo, (Field)field);
        }
        catch (Exception ee) {
            throw new ProtobufAnnotationException("Could not execute getter " + getter + " on class " + pojo.getClass().getCanonicalName() + ": " + ee, ee);
        }
        if (value == null && protobufAttribute.required()) {
            throw new ProtobufAnnotationException("Required field " + field.getName() + " on class " + pojo.getClass().getCanonicalName() + " is null");
        }
        return value;
    }

    private static final Object getProtobufFieldValue(Message protoBuf, ProtobufAttribute protobufAttribute, Field field) throws JException, InstantiationException, IllegalAccessException {
        String haser;
        boolean fieldIsSet;
        String fieldName = field.getName();
        String upperCaseFirstFieldName = JStringUtils.upperCaseFirst((String)fieldName);
        String getter = ProtobufSerializerUtils.getProtobufGetter(protobufAttribute, field);
        Boolean isCollection = Boolean.FALSE;
        if (Collection.class.isAssignableFrom(field.getType())) {
            isCollection = Boolean.TRUE;
        }
        if (!isCollection.booleanValue() && !(fieldIsSet = ((Boolean)JReflectionUtils.runMethod((Object)protoBuf, (String)(haser = StringUtils.replaceOnce((String)getter, (String)"get", (String)"has")), (Object[])null)).booleanValue())) {
            return null;
        }
        Object protobufValue = JReflectionUtils.runMethod((Object)protoBuf, (String)getter, (Object[])null);
        if (isCollection.booleanValue() && ((Collection)protobufValue).isEmpty()) {
            return null;
        }
        if (protobufValue instanceof GeneratedMessage && ProtobufSerializerUtils.isProtbufEntity(field.getType())) {
            protobufValue = ProtobufSerializer.serializeFromProtobufEntity((Message)protobufValue, field.getType());
        }
        if (protobufValue instanceof Collection && ((Collection)(protobufValue = ProtobufSerializer.convertCollectionFromProtobufs(field, (Collection)protobufValue))).isEmpty()) {
            return null;
        }
        return protobufValue;
    }

    private static final Object serializeToProtobufEntity(Object pojo) throws JException {
        ProtobufEntity protoBufEntity = ProtobufSerializerUtils.getProtobufEntity(pojo.getClass());
        if (protoBufEntity == null) {
            return pojo;
        }
        return new ProtobufSerializer().toProtobuf(pojo);
    }

    private static final Object serializeFromProtobufEntity(Message protoBuf, Class<?> pojoClazz) throws JException {
        ProtobufEntity protoBufEntity = ProtobufSerializerUtils.getProtobufEntity(pojoClazz);
        if (protoBufEntity == null) {
            return protoBuf;
        }
        return new ProtobufSerializer().fromProtobuf(protoBuf, pojoClazz);
    }

    private static final Object convertCollectionToProtobufs(Collection<Object> collectionOfNonProtobufs) throws JException {
        if (collectionOfNonProtobufs.isEmpty()) {
            return collectionOfNonProtobufs;
        }
        Object first = collectionOfNonProtobufs.toArray()[0];
        if (!ProtobufSerializerUtils.isProtbufEntity(first)) {
            return collectionOfNonProtobufs;
        }
        AbstractCollection newCollectionValues = collectionOfNonProtobufs instanceof Set ? new HashSet() : new ArrayList();
        for (Object iProtobufGenObj : collectionOfNonProtobufs) {
            newCollectionValues.add(ProtobufSerializer.serializeToProtobufEntity(iProtobufGenObj));
        }
        return newCollectionValues;
    }

    private static Object convertCollectionFromProtobufs(Field field, Collection<?> collectionOfProtobufs) throws JException, InstantiationException, IllegalAccessException {
        if (collectionOfProtobufs.isEmpty()) {
            return collectionOfProtobufs;
        }
        ParameterizedType listType = (ParameterizedType)field.getGenericType();
        Class collectionClazzType = (Class)listType.getActualTypeArguments()[0];
        ProtobufEntity protoBufEntityAnno = ProtobufSerializerUtils.getProtobufEntity(collectionClazzType);
        Object first = collectionOfProtobufs.toArray()[0];
        if (!(first instanceof GeneratedMessage) && protoBufEntityAnno == null) {
            return collectionOfProtobufs;
        }
        ArrayList<Object> newCollectionOfValues = new ArrayList<Object>();
        for (Object protobufValue : collectionOfProtobufs) {
            if (!(protobufValue instanceof GeneratedMessage)) {
                throw new ProtobufException("Collection contains an object of type " + protobufValue.getClass() + " which is not an instanceof GeneratedMessage, can not (de)serialize this");
            }
            newCollectionOfValues.add(ProtobufSerializer.serializeFromProtobufEntity((Message)protobufValue, collectionClazzType));
        }
        return newCollectionOfValues;
    }

    private static final void setProtobufFieldValue(ProtobufAttribute protobufAttribute, Message.Builder protoObjBuilder, String setter, Object fieldValue) throws NoSuchMethodException, SecurityException, ProtobufAnnotationException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> fieldValueClass;
        Class<Object> gpbClass = fieldValueClass = fieldValue.getClass();
        Class<? extends IProtobufConverter> converterClazz = protobufAttribute.converter();
        if (converterClazz != NullConverter.class) {
            IProtobufConverter protoBufConverter = converterClazz.newInstance();
            fieldValue = protoBufConverter.convertToProtobuf(fieldValue);
            fieldValueClass = gpbClass = fieldValue.getClass();
        }
        gpbClass = ProtobufSerializerUtils.getProtobufClass(fieldValue, gpbClass);
        Method gpbMethod = protoObjBuilder.getClass().getDeclaredMethod(setter, gpbClass);
        gpbMethod.invoke((Object)protoObjBuilder, fieldValue);
    }

    private static final void setPojoFieldValue(Object pojo, String setter, Object protobufValue, ProtobufAttribute protobufAttribute) throws InstantiationException, IllegalAccessException, JException {
        Class<? extends IProtobufConverter> fromProtoBufConverter = protobufAttribute.converter();
        if (fromProtoBufConverter != NullConverter.class) {
            IProtobufConverter converter = fromProtoBufConverter.newInstance();
            protobufValue = converter.convertFromProtobuf(protobufValue);
        }
        Class<?> argClazz = protobufValue.getClass();
        JReflectionUtils.runSetter((Object)pojo, (String)setter, (Object)protobufValue, argClazz);
    }
}

