/*
 * Decompiled with CFR 0.152.
 */
package ca.islandora.indexing.triplestore;

import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.fcrepo.camel.processor.SparqlDeleteProcessor;
import org.fcrepo.camel.processor.SparqlUpdateProcessor;

public class TriplestoreIndexer
extends RouteBuilder {
    public void configure() {
        Predicate isTriples = this.header("Content-Type").isEqualTo((Object)"application/n-triples");
        Predicate hasBaseUrl = this.header("CamelFcrepoBaseUrl").isNotNull();
        Predicate hasIdentifier = this.header("CamelFcrepoIdentifier").isNotNull();
        Predicate hasFcrepoCamelHeaders = PredicateBuilder.and((Predicate)hasBaseUrl, (Predicate)hasIdentifier);
        Predicate hasAction = PredicateBuilder.or((Predicate)this.header("action").isEqualTo((Object)"delete"), (Predicate)this.header("action").isEqualTo((Object)"upsert"));
        Predicate isValid = PredicateBuilder.and((Predicate[])new Predicate[]{isTriples, hasFcrepoCamelHeaders, hasAction});
        this.onException(Exception.class).maximumRedeliveries("{{error.maxRedeliveries}}").log(LoggingLevel.ERROR, "Error Indexing in Triplestore: ${routeId}");
        ((ChoiceDefinition)this.from("{{input.stream}}").routeId("IslandoraTriplestoreIndexerRouter").filter(isValid).choice().when(this.header("action").isEqualTo((Object)"delete")).to("direct:triplestoreDelete")).otherwise().to("direct:triplestoreUpsert");
        ((RouteDefinition)this.from("direct:triplestoreUpsert").routeId("islandoraTripelstoreIndexerUpsert").process((Processor)new SparqlUpdateProcessor())).to("http4://{{triplestore.baseUrl}}");
        ((RouteDefinition)this.from("direct:triplestoreDelete").routeId("islandoraTripelstoreIndexerDelete").process((Processor)new SparqlDeleteProcessor())).to("http4://{{triplestore.baseUrl}}");
    }
}

