/*
 * Decompiled with CFR 0.152.
 */
package ca.islandora.alpaca.indexing.fcrepo;

import ca.islandora.alpaca.support.event.AS2Event;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.PropertyInject;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.http.common.HttpOperationFailedException;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcrepoIndexer
extends RouteBuilder {
    public static final String FEDORA_HEADER = "X-Islandora-Fedora-Endpoint";
    @PropertyInject(value="error.maxRedeliveries")
    private int maxRedeliveries;
    @PropertyInject(value="milliner.baseUrl")
    private String millinerBaseUrl;
    @PropertyInject(value="gemini.baseUrl")
    private String geminiBaseUrl;
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoIndexer.class);

    public int getMaxRedeliveries() {
        return this.maxRedeliveries;
    }

    public void setMaxRedeliveries(int maxRedeliveries) {
        this.maxRedeliveries = maxRedeliveries;
    }

    public String getMillinerBaseUrl() {
        return this.enforceTrailingSlash(this.millinerBaseUrl);
    }

    public void setMillinerBaseUrl(String millinerBaseUrl) {
        this.millinerBaseUrl = millinerBaseUrl;
    }

    public String getGeminiBaseUrl() {
        return this.enforceTrailingSlash(this.geminiBaseUrl);
    }

    public void setGeminiBaseUrl(String geminiBaseUrl) {
        this.geminiBaseUrl = geminiBaseUrl;
    }

    private String enforceTrailingSlash(String baseUrl) {
        String trimmed = baseUrl.trim();
        return trimmed.endsWith("/") ? trimmed : trimmed + "/";
    }

    public void configure() {
        Predicate is412 = PredicateBuilder.toPredicate((Expression)this.simple("${exception.statusCode} == 412"));
        Predicate is404 = PredicateBuilder.toPredicate((Expression)this.simple("${exception.statusCode} == 404"));
        this.onException(HttpOperationFailedException.class).onWhen(is412).useOriginalMessage().handled(true).log(LoggingLevel.INFO, LOGGER, "Received 412 from Milliner, skipping indexing.");
        this.onException(Exception.class).maximumRedeliveries(this.maxRedeliveries).log(LoggingLevel.ERROR, LOGGER, "Error indexing resource in fcrepo: ${exception.message}\n\n${exception.stacktrace}");
        ((ChoiceDefinition)((ChoiceDefinition)((MulticastDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("{{node.stream}}").routeId("FcrepoIndexerNode").unmarshal().json(JsonLibrary.Jackson, AS2Event.class).setProperty("event").simple("${body}")).setProperty("uuid").simple("${exchangeProperty.event.object.id.replaceAll(\"urn:uuid:\",\"\")}")).setProperty("jsonldUrl").simple("${exchangeProperty.event.object.url[2].href}")).setProperty("fedoraBaseUrl").simple("${exchangeProperty.event.target}")).log(LoggingLevel.DEBUG, LOGGER, "Received Node event for UUID (${exchangeProperty.uuid}), jsonld URL (${exchangeProperty.jsonldUrl}), fedora base URL (${exchangeProperty.fedoraBaseUrl})")).removeHeaders("*", new String[]{"Authorization"})).setHeader("CamelHttpMethod", (Expression)this.constant("POST"))).setHeader("Content-Location", (Expression)this.simple("${exchangeProperty.jsonldUrl}"))).setHeader(FEDORA_HEADER, (Expression)this.exchangeProperty("fedoraBaseUrl"))).setBody((Expression)this.simple("${null}"))).multicast().parallelProcessing().toD(this.getMillinerBaseUrl() + "node/${exchangeProperty.uuid}?connectionClose=true")).choice().when().simple("${exchangeProperty.event.object.isNewVersion}")).toD(this.getMillinerBaseUrl() + "version/${exchangeProperty.uuid}?connectionClose=true")).endChoice();
        ((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)((OnExceptionDefinition)this.from("{{node.delete.stream}}").routeId("FcrepoIndexerDeleteNode").onException(HttpOperationFailedException.class).onWhen(is404).useOriginalMessage().handled(true).log(LoggingLevel.INFO, LOGGER, "Received 404 from Milliner, skipping de-indexing.")).end().unmarshal().json(JsonLibrary.Jackson, AS2Event.class).setProperty("event").simple("${body}")).setProperty("uuid").simple("${exchangeProperty.event.object.id.replaceAll(\"urn:uuid:\",\"\")}")).setProperty("fedoraBaseUrl").simple("${exchangeProperty.event.target}")).log(LoggingLevel.DEBUG, LOGGER, "Received Node delete event for UUID (${exchangeProperty.uuid}), fedora base URL (${exchangeProperty.fedoraBaseUrl})").removeHeaders("*", new String[]{"Authorization"}).setHeader("CamelHttpMethod", (Expression)this.constant("DELETE")).setHeader(FEDORA_HEADER, (Expression)this.exchangeProperty("fedoraBaseUrl")).setBody((Expression)this.simple("${null}")).toD(this.getMillinerBaseUrl() + "node/${exchangeProperty.uuid}?connectionClose=true");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("{{media.stream}}").routeId("FcrepoIndexerMedia").unmarshal().json(JsonLibrary.Jackson, AS2Event.class).setProperty("event").simple("${body}")).setProperty("sourceField").simple("${exchangeProperty.event.attachment.content.sourceField}")).setProperty("jsonUrl").simple("${exchangeProperty.event.object.url[1].href}")).setProperty("fedoraBaseUrl").simple("${exchangeProperty.event.target}")).log(LoggingLevel.DEBUG, LOGGER, "Received Media event for sourceField (${exchangeProperty.sourceField}), jsonld URL (${exchangeProperty.jsonUrl}), fedora Base URL (${exchangeProperty.fedoraBaseUrl})")).removeHeaders("*", new String[]{"Authorization"})).setHeader("CamelHttpMethod", (Expression)this.constant("POST"))).setHeader("Content-Location", (Expression)this.simple("${exchangeProperty.jsonUrl}"))).setHeader(FEDORA_HEADER, (Expression)this.exchangeProperty("fedoraBaseUrl"))).setBody((Expression)this.simple("${null}"))).toD(this.getMillinerBaseUrl() + "media/${exchangeProperty.sourceField}?connectionClose=true");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("{{file.stream}}").routeId("FcrepoIndexerFile").unmarshal().json(JsonLibrary.Jackson, AS2Event.class).setProperty("event").simple("${body}")).setProperty("uuid").simple("${exchangeProperty.event.object.id.replaceAll(\"urn:uuid:\",\"\")}")).setProperty("drupal").simple("${exchangeProperty.event.object.url[0].href}")).setProperty("fedora").simple("${exchangeProperty.event.attachment.content.fedoraUri}")).setProperty("fedoraBaseUrl").simple("${exchangeProperty.event.target}")).log(LoggingLevel.DEBUG, LOGGER, "Received File event for UUID (${exchangeProperty.uuid}), drupal URL (${exchangeProperty.drupal}), fedoraURL (${exchangeProperty.fedora}), fedora base URL (${exchangeProperty.fedoraBaseUrl})")).removeHeaders("*", new String[]{"Authorization"})).setHeader("Content-Type", (Expression)this.constant("application/json"))).setHeader("CamelHttpMethod", (Expression)this.constant("PUT"))).setHeader(FEDORA_HEADER, (Expression)this.exchangeProperty("fedoraBaseUrl"))).setBody((Expression)this.simple("{\"drupal\": \"${exchangeProperty.drupal}\", \"fedora\": \"${exchangeProperty.fedora}\"}"))).toD(this.getGeminiBaseUrl() + "${exchangeProperty.uuid}?connectionClose=true");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("{{file.external.stream}}").routeId("FcrepoIndexerExternalFile").unmarshal().json(JsonLibrary.Jackson, AS2Event.class).setProperty("event").simple("${body}")).setProperty("uuid").simple("${exchangeProperty.event.object.id.replaceAll(\"urn:uuid:\",\"\")}")).setProperty("drupal").simple("${exchangeProperty.event.object.url[0].href}")).setProperty("fedoraBaseUrl").simple("${exchangeProperty.event.target}")).log(LoggingLevel.DEBUG, LOGGER, "Received File external event for UUID (${exchangeProperty.uuid}), drupal URL (${exchangeProperty.drupal}), fedora base URL (${exchangeProperty.fedoraBaseUrl})")).removeHeaders("*", new String[]{"Authorization"})).setHeader("CamelHttpMethod", (Expression)this.constant("POST"))).setHeader("Content-Location", (Expression)this.simple("${exchangeProperty.drupal}"))).setHeader(FEDORA_HEADER, (Expression)this.exchangeProperty("fedoraBaseUrl"))).setBody((Expression)this.simple("${null}"))).toD(this.getMillinerBaseUrl() + "external/${exchangeProperty.uuid}?connectionClose=true");
    }
}

