/*
 * Decompiled with CFR 0.152.
 */
package ca.islandora.alpaca.indexing.fcrepo;

import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.PropertyInject;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.http.common.HttpOperationFailedException;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcrepoIndexer
extends RouteBuilder {
    @PropertyInject(value="error.maxRedeliveries")
    private int maxRedeliveries;
    @PropertyInject(value="milliner.baseUrl")
    private String millinerBaseUrl;
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoIndexer.class);

    public int getMaxRedeliveries() {
        return this.maxRedeliveries;
    }

    public void setMaxRedeliveries(int maxRedeliveries) {
        this.maxRedeliveries = maxRedeliveries;
    }

    public String getMillinerBaseUrl() {
        String trimmed = this.millinerBaseUrl.trim();
        return trimmed.endsWith("/") ? trimmed : trimmed + "/";
    }

    public void setMillinerBaseUrl(String millinerBaseUrl) {
        this.millinerBaseUrl = millinerBaseUrl;
    }

    public void configure() {
        Predicate is412 = PredicateBuilder.toPredicate((Expression)this.simple("${exception.statusCode} == 412"));
        this.onException(HttpOperationFailedException.class).onWhen(is412).useOriginalMessage().handled(true).log(LoggingLevel.INFO, LOGGER, "Received 412 from Milliner, skipping indexing.");
        this.onException(Exception.class).maximumRedeliveries(this.maxRedeliveries).log(LoggingLevel.ERROR, LOGGER, "Error indexing resource in fcrepo: ${exception.message}\n\n${exception.stacktrace}");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("{{content.stream}}").routeId("FcrepoIndexerContent").removeHeaders("*", new String[]{"Authorization"})).setHeader("Content-Type", (Expression)this.constant("application/ld+json"))).setHeader("CamelHttpMethod", (Expression)this.constant("POST"))).toD(this.getMillinerBaseUrl() + "content");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("{{file.stream}}").routeId("FcrepoIndexerFile").removeHeaders("*", new String[]{"Authorization"})).setHeader("Content-Type", (Expression)this.constant("application/ld+json"))).setHeader("CamelHttpMethod", (Expression)this.constant("POST"))).to(this.getMillinerBaseUrl() + "file");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("{{media.stream}}").routeId("FcrepoIndexerMedia").removeHeaders("*", new String[]{"Authorization"})).setHeader("Content-Type", (Expression)this.constant("application/ld+json"))).setHeader("CamelHttpMethod", (Expression)this.constant("POST"))).to(this.getMillinerBaseUrl() + "media");
        ((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("{{delete.stream}}").routeId("FcrepoIndexerDelete").setProperty("urn").jsonpath("$.object.id")).setProperty("uuid").simple("${exchangeProperty.urn.replaceAll(\"urn:uuid:\",\"\")}")).removeHeaders("*", new String[]{"Authorization"})).setHeader("CamelHttpMethod", (Expression)this.constant("DELETE"))).toD(this.getMillinerBaseUrl() + "resource/${exchangeProperty.uuid}");
    }
}

