/*
 * Decompiled with CFR 0.152.
 */
package ca.islandora.alpaca.http.client;

import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class StaticTokenRequestInterceptor
implements HttpRequestInterceptor {
    public static final String AUTH_HEADER = "Authorization";
    private Header header;

    public StaticTokenRequestInterceptor() {
    }

    public StaticTokenRequestInterceptor(String token) {
        this.header = StaticTokenRequestInterceptor.makeHeader(token);
    }

    public void setToken(String token) {
        this.header = StaticTokenRequestInterceptor.makeHeader(token);
    }

    private static Header makeHeader(String token) {
        return new BasicHeader(AUTH_HEADER, "Bearer " + Objects.requireNonNull(token, "Token must not be null!"));
    }

    public void process(HttpRequest request, HttpContext context) {
        if (request.getFirstHeader(AUTH_HEADER) == null) {
            request.addHeader(this.header);
        }
    }

    public static HttpClient defaultClient(StaticTokenRequestInterceptor interceptor) {
        PoolingHttpClientConnectionManager connMan = new PoolingHttpClientConnectionManager();
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connMan).setConnectionManagerShared(true).addInterceptorFirst((HttpRequestInterceptor)interceptor).build();
    }
}

