/*
 * Decompiled with CFR 0.152.
 */
package ca.grimoire.mainspring;

import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class Bootstrap {
    public static final String DEFAULT_CONTEXT = "META-INF/mainspring.xml";

    public static void main(String[] args) {
        AbstractXmlApplicationContext context = Bootstrap.createContext(args);
        context.registerShutdownHook();
        context.afterPropertiesSet();
    }

    private static AbstractXmlApplicationContext createContext(String[] args) {
        if (args != null && args.length > 0) {
            return Bootstrap.createArgumentContext(args);
        }
        return Bootstrap.createDefaultContext();
    }

    private static AbstractXmlApplicationContext createArgumentContext(String[] args) {
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext();
        context.setConfigLocations(args);
        return context;
    }

    private static AbstractXmlApplicationContext createDefaultContext() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext();
        context.setConfigLocation(DEFAULT_CONTEXT);
        return context;
    }
}

