/*
 * Decompiled with CFR 0.152.
 */
package ca.grimoire.logging.annotations;

import ca.grimoire.logging.annotations.LogBefore;
import ca.grimoire.logging.annotations.LogException;
import ca.grimoire.logging.annotations.LogReturn;
import ca.grimoire.logging.annotations.Severity;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodLoggingAdvice {
    public void logBefore(JoinPoint call, LogBefore logAnnotation) {
        this.emit(call, logAnnotation.value(), logAnnotation.severity(), call.getArgs());
    }

    public void logReturn(JoinPoint call, LogReturn logAnnotation, Object returnValue) {
        this.emit(call, logAnnotation.value(), logAnnotation.severity(), returnValue);
    }

    public void logException(JoinPoint call, LogException logAnnotation, Throwable exception) {
        this.emitException(call, logAnnotation.value(), logAnnotation.severity(), exception);
    }

    private void emit(JoinPoint call, String message, Severity severity, Object ... values) {
        Logger logger = this.extractLogger(call);
        severity.log(logger, message, values);
    }

    private void emitException(JoinPoint call, String message, Severity severity, Throwable exception) {
        Logger logger = this.extractLogger(call);
        severity.logException(logger, message, exception);
    }

    private Logger extractLogger(JoinPoint call) {
        Signature signature = call.getSignature();
        Class declaringType = signature.getDeclaringType();
        Logger logger = LoggerFactory.getLogger((Class)declaringType);
        return logger;
    }
}

