/*
 * Decompiled with CFR 0.152.
 */
package ca.grimoire.jnoise.examples;

import ca.grimoire.jnoise.config.ConfigurationException;
import ca.grimoire.jnoise.config.NoiseConfiguration;
import ca.grimoire.jnoise.config.XMLConfigurationLoader;
import ca.grimoire.jnoise.examples.ImageBuilder;
import ca.grimoire.jnoise.models.PlaneModel;
import ca.grimoire.jnoise.modules.Module;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;

public final class ShowNoise {
    private static final int HEIGHT = 500;
    private static final int WIDTH = 500;
    private static final double OX = -2.5;
    private static final double OY = -2.5;
    private static final double OZ = 0.0;
    private static final double UX = 5.0;
    private static final double UY = 0.0;
    private static final double UZ = 0.0;
    private static final double VX = 0.0;
    private static final double VY = 5.0;
    private static final double VZ = 0.0;
    private static final String BUILTIN_CONFIG_RESOURCE = "ca/grimoire/jnoise/examples/modules.xml";
    private static final String USER_CONFIG_FILE = "jnoise.xml";
    private static final String USER_CONFIG_RESOURCE = "jnoise.xml";

    public static void main(String[] args) throws IOException, ConfigurationException {
        final Module[] modules = ShowNoise.loadModules();
        Image image = ShowNoise.createImage(modules[0]);
        final JFrame window = new JFrame("Showing Noise");
        final ImageIcon icon = new ImageIcon();
        final JComboBox<Module> selector = new JComboBox<Module>(modules);
        window.getContentPane().setLayout(new BorderLayout());
        window.getContentPane().add((Component)new JLabel(icon), "Center");
        window.getContentPane().add(selector, "North");
        selector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                icon.setImage(ShowNoise.createImage(modules[selector.getSelectedIndex()]));
                window.repaint();
            }
        });
        icon.setImage(image);
        window.setResizable(false);
        window.pack();
        window.setDefaultCloseOperation(3);
        window.setVisible(true);
    }

    private static Module[] loadModules() throws IOException, ConfigurationException {
        NoiseConfiguration config = ShowNoise.loadConfiguration();
        List moduleList = config.getNoiseModules();
        return moduleList.toArray(new Module[moduleList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NoiseConfiguration loadConfiguration() throws IOException, ConfigurationException {
        XMLConfigurationLoader configurator = new XMLConfigurationLoader();
        InputStream in = ShowNoise.openConfigStream();
        try {
            InputStreamReader reader = new InputStreamReader(in);
            NoiseConfiguration noiseConfiguration = configurator.loadConfiguration((Reader)reader);
            return noiseConfiguration;
        }
        finally {
            in.close();
        }
    }

    private static InputStream openConfigStream() {
        try {
            return ShowNoise.openFileStream("jnoise.xml");
        }
        catch (IOException ioe) {
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            InputStream resStream = ShowNoise.openResourceStream(classloader, "jnoise.xml");
            if (resStream == null) {
                resStream = ShowNoise.openResourceStream(classloader, BUILTIN_CONFIG_RESOURCE);
            }
            return resStream;
        }
    }

    private static InputStream openFileStream(String file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private static InputStream openResourceStream(ClassLoader classloader, String resource) {
        return classloader.getResourceAsStream(resource);
    }

    static Image createImage(Module module) {
        PlaneModel plane = new PlaneModel(module, -2.5, -2.5, 0.0, 5.0, 0.0, 0.0, 0.0, 5.0, 0.0);
        ImageBuilder builder = new ImageBuilder(plane, 1.0, 1.0);
        Image image = builder.createImage(500, 500);
        return image;
    }
}

