/*
 * Decompiled with CFR 0.152.
 */
package ca.grimoire.jnoise.examples;

import ca.grimoire.jnoise.models.PlaneModel;
import ca.grimoire.jnoise.palettes.CorrectedMonochrome;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public final class ImageBuilder {
    private final PlaneModel model;
    private final double uExtent;
    private final double vExtent;

    private static double interpolate(int value, int limit, double extent) {
        double ratio = value;
        return (ratio /= (double)limit) * extent;
    }

    public ImageBuilder(PlaneModel model, double u, double v) {
        assert (model != null);
        this.model = model;
        this.uExtent = u;
        this.vExtent = v;
    }

    public Image createImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double total = 0.0;
        double[][] samples = new double[height][width];
        for (int row = 0; row < height; ++row) {
            double y = ImageBuilder.interpolate(row, height, this.uExtent);
            for (int col = 0; col < width; ++col) {
                double x = ImageBuilder.interpolate(col, width, this.vExtent);
                double v = this.model.getValue(x, y);
                min = Math.min(min, v);
                max = Math.max(max, v);
                total += v;
                samples[row][col] = v;
            }
        }
        double average = total / (double)(height * width);
        double gamma = (average - min) / (max - average);
        CorrectedMonochrome palette = new CorrectedMonochrome(min, max, gamma);
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                Color color = palette.getColor(samples[row][col]);
                g.setColor(color);
                g.drawLine(col, row, col, row);
            }
        }
        return image;
    }
}

