/*
 * Decompiled with CFR 0.152.
 */
package ca.grimoire.formtree.receiver.constructor;

import ca.grimoire.formtree.FormElementReceiver;
import ca.grimoire.formtree.FormReceiver;
import ca.grimoire.formtree.receiver.IgnoreReceiver;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;

public class StringConstructorReceiver<T>
implements FormReceiver<T> {
    private final Constructor<T> constructor;
    private String value = null;

    public static boolean accepts(Class<?> formClass) {
        try {
            formClass.getConstructor(String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static <T> StringConstructorReceiver<T> create(Class<T> parameterType) {
        return new StringConstructorReceiver<T>(parameterType);
    }

    public StringConstructorReceiver(Class<T> valueClass) {
        try {
            this.constructor = valueClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Class %s has no constructor accepting a single String.", valueClass), e);
        }
    }

    @Override
    public T finished() {
        try {
            return this.constructor.newInstance(this.value);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(String.format("Unable to create instances of %s.", this.constructor.getDeclaringClass()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Unable to create instances of %s.", this.constructor.getDeclaringClass()), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(String.format("Unable to create instances of %s.", this.constructor.getDeclaringClass()), e);
        }
    }

    @Override
    public FormElementReceiver key(String field) {
        return IgnoreReceiver.IGNORE;
    }

    @Override
    public FormElementReceiver index(int index) {
        return IgnoreReceiver.IGNORE;
    }

    @Override
    public void values(Iterable<String> values) {
        Iterator<String> iterator = values.iterator();
        if (iterator.hasNext()) {
            this.value = iterator.next();
        }
    }
}

