/*
 * Decompiled with CFR 0.152.
 */
package ca.grimoire.formtree.receiver.constructor;

import ca.grimoire.formtree.FormElementReceiver;
import ca.grimoire.formtree.FormReceiver;
import ca.grimoire.formtree.receiver.IgnoreReceiver;
import ca.grimoire.formtree.receiver.annotations.FormField;
import ca.grimoire.formtree.receiver.constructor.ArrayReceiver;
import ca.grimoire.formtree.receiver.constructor.ListReceiver;
import ca.grimoire.formtree.receiver.constructor.SetReceiver;
import ca.grimoire.formtree.receiver.constructor.StringConstructorReceiver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConstructorReceiver<T>
implements FormReceiver<T> {
    private final Constructor<T> constructor;
    private final LinkedHashMap<String, FormReceiver<?>> receivers = new LinkedHashMap();

    public static boolean accepts(Class<?> formClass) {
        return ConstructorReceiver.findFormConstructor(formClass) != null;
    }

    public static <T> ConstructorReceiver<T> create(Class<T> elementClass) {
        return new ConstructorReceiver<T>(elementClass);
    }

    private static String fieldNameFromAnnotations(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != FormField.class) continue;
            FormField formFieldAnnotation = (FormField)annotation;
            return formFieldAnnotation.value();
        }
        throw new IllegalArgumentException("Annotation list does not contain FormField annotation.");
    }

    private static <T> Constructor<T> findFormConstructor(Class<T> elementClass) {
        for (Constructor<?> constructor : elementClass.getConstructors()) {
            Annotation[][] parametersAnnotations = constructor.getParameterAnnotations();
            boolean isFormConstructor = true;
            for (Annotation[] parameterAnnotations : parametersAnnotations) {
                boolean hasFormFieldAnnotation = false;
                for (Annotation annotation : parameterAnnotations) {
                    if (annotation.annotationType() != FormField.class) continue;
                    hasFormFieldAnnotation = true;
                }
                isFormConstructor &= hasFormFieldAnnotation;
            }
            if (!(isFormConstructor &= parametersAnnotations.length > 0)) continue;
            Constructor<?> typeCorrectedConstructor = constructor;
            return typeCorrectedConstructor;
        }
        return null;
    }

    public ConstructorReceiver(Class<T> formClass) {
        this.constructor = ConstructorReceiver.findFormConstructor(formClass);
        if (this.constructor == null) {
            throw new IllegalArgumentException(String.format("The class %s has no suitable form constructor.", new Object[0]));
        }
        this.prepareReceivers();
    }

    @Override
    public T finished() {
        ArrayList parameters = new ArrayList();
        for (Map.Entry<String, FormReceiver<?>> receiver : this.receivers.entrySet()) {
            parameters.add(receiver.getValue().finished());
        }
        try {
            return this.constructor.newInstance(parameters.toArray());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(String.format("Unable to create instances of %s.", this.constructor.getDeclaringClass()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Unable to create instances of %s.", this.constructor.getDeclaringClass()), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(String.format("Unable to create instances of %s.", this.constructor.getDeclaringClass()), e);
        }
    }

    @Override
    public FormElementReceiver key(String field) {
        FormReceiver<?> receiver = this.receivers.get(field);
        if (receiver != null) {
            return receiver;
        }
        return IgnoreReceiver.IGNORE;
    }

    @Override
    public FormElementReceiver index(int index) {
        return IgnoreReceiver.IGNORE;
    }

    @Override
    public void values(Iterable<String> values) {
    }

    private void prepareReceivers() {
        Annotation[][] parameterAnnotationLists = this.constructor.getParameterAnnotations();
        Class<?>[] parameterTypes = this.constructor.getParameterTypes();
        Type[] parameterGenericTypes = this.constructor.getGenericParameterTypes();
        assert (parameterTypes.length == parameterAnnotationLists.length);
        assert (parameterTypes.length == parameterGenericTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            String fieldName = ConstructorReceiver.fieldNameFromAnnotations(parameterAnnotationLists[i]);
            Class<?> parameterType = parameterTypes[i];
            Type parameterGenericType = parameterGenericTypes[i];
            FormReceiver<?> receiver = this.prepareConstructorReceiver(parameterType);
            if (receiver == null) {
                receiver = this.prepareListReceiver(parameterGenericType);
            }
            if (receiver == null) {
                receiver = this.prepareSetReceiver(parameterGenericType);
            }
            if (receiver == null) {
                receiver = this.prepareArrayReceiver(parameterType);
            }
            if (receiver == null) {
                receiver = this.prepareStringReceiver(parameterType);
            }
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Unable to determine form data bindings for all parameters of %s (failed at parameter %d).", this.constructor, i));
            }
            this.receivers.put(fieldName, receiver);
        }
    }

    private ArrayReceiver<?> prepareArrayReceiver(Class<?> parameterType) {
        Class<?> elementClass = ArrayReceiver.acceptableArrayClass(parameterType);
        if (elementClass != null) {
            return ArrayReceiver.create(elementClass);
        }
        return null;
    }

    private ConstructorReceiver<?> prepareConstructorReceiver(Class<?> parameterType) {
        if (ConstructorReceiver.accepts(parameterType)) {
            return ConstructorReceiver.create(parameterType);
        }
        return null;
    }

    private ListReceiver<?> prepareListReceiver(Type parameterGenericType) {
        Class<?> elementClass = ListReceiver.acceptableListType(parameterGenericType);
        if (elementClass != null) {
            return ListReceiver.create(elementClass);
        }
        return null;
    }

    private SetReceiver<?> prepareSetReceiver(Type parameterGenericType) {
        Class<?> elementClass = SetReceiver.acceptableSetType(parameterGenericType);
        if (elementClass != null) {
            return SetReceiver.create(elementClass);
        }
        return null;
    }

    private StringConstructorReceiver<?> prepareStringReceiver(Class<?> parameterType) {
        if (StringConstructorReceiver.accepts(parameterType)) {
            return StringConstructorReceiver.create(parameterType);
        }
        return null;
    }
}

