/*
 * Decompiled with CFR 0.152.
 */
package ca.grimoire.formtree.receiver.constructor;

import ca.grimoire.formtree.receiver.constructor.CollectionReceiver;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SetReceiver<T>
extends CollectionReceiver<T, Set<T>> {
    public static Class<?> acceptableSetType(Type type) {
        try {
            ParameterizedType listType = (ParameterizedType)type;
            if (listType.getRawType() != Set.class) {
                return null;
            }
            return SetReceiver.acceptableElementClass(listType);
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public static <T> SetReceiver<T> create(Class<T> elementClass) {
        return new SetReceiver<T>(elementClass);
    }

    public SetReceiver(Class<T> elementClass) {
        super(elementClass);
    }

    @Override
    protected Set<T> createCollection(List<T> elements) {
        return new HashSet<T>(elements);
    }
}

