/*
 * Decompiled with CFR 0.152.
 */
package ca.grimoire.formtree.receiver.constructor;

import ca.grimoire.formtree.FormElementReceiver;
import ca.grimoire.formtree.FormReceiver;
import ca.grimoire.formtree.receiver.IgnoreReceiver;
import ca.grimoire.formtree.receiver.constructor.ConstructorReceiver;
import ca.grimoire.formtree.receiver.constructor.StringConstructorReceiver;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class CollectionReceiver<E, T>
implements FormReceiver<T> {
    protected final Class<E> elementClass;
    private ArrayList<FormReceiver<E>> elementReceivers = this.reset();
    private final ElementReceiverFactory<E> elementReceiverFactory;

    public static Class<?> acceptableElementClass(ParameterizedType collectionType) {
        try {
            Class<?> listElementClass = CollectionReceiver.extractSingleParameterType(collectionType);
            return CollectionReceiver.acceptableElementClass(listElementClass);
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public static Class<?> acceptableElementClass(Class<?> elementClass) {
        if (!ConstructorReceiver.accepts(elementClass) && !StringConstructorReceiver.accepts(elementClass)) {
            return null;
        }
        return elementClass;
    }

    private static Class<?> extractSingleParameterType(ParameterizedType pt) {
        Type[] typeArguments = pt.getActualTypeArguments();
        assert (typeArguments.length == 1);
        Class listElementClass = (Class)typeArguments[0];
        return listElementClass;
    }

    public CollectionReceiver(Class<E> elementClass) {
        this.elementClass = elementClass;
        if (ConstructorReceiver.accepts(elementClass)) {
            this.elementReceiverFactory = new ConstructorReceiverFactory<E>(elementClass);
        } else if (StringConstructorReceiver.accepts(elementClass)) {
            this.elementReceiverFactory = new StringConstructorReceiverFactory<E>(elementClass);
        } else {
            throw new IllegalArgumentException(String.format("%s is not an acceptable list element.", elementClass));
        }
    }

    @Override
    public FormElementReceiver index(int index) {
        this.growToIndex(index);
        return this.elementReceivers.get(index);
    }

    @Override
    public FormElementReceiver key(String field) {
        return IgnoreReceiver.IGNORE;
    }

    @Override
    public void values(Iterable<String> values) {
        this.elementReceivers = this.reset();
        for (String value : values) {
            FormReceiver<E> elementReceiver = this.elementReceiverFactory.create();
            elementReceiver.values(Arrays.asList(value));
            this.elementReceivers.add(elementReceiver);
        }
    }

    @Override
    public T finished() {
        ArrayList<E> elements = new ArrayList<E>();
        for (FormReceiver<E> elementReceiver : this.elementReceivers) {
            if (elementReceiver == null) continue;
            elements.add(elementReceiver.finished());
        }
        return this.createCollection(elements);
    }

    protected abstract T createCollection(List<E> var1);

    private void growToIndex(int index) {
        this.elementReceivers.ensureCapacity(index + 1);
        while (this.elementReceivers.size() <= index) {
            this.elementReceivers.add(this.elementReceiverFactory.create());
        }
    }

    private ArrayList<FormReceiver<E>> reset() {
        return new ArrayList<FormReceiver<E>>();
    }

    private static class StringConstructorReceiverFactory<E>
    implements ElementReceiverFactory<E> {
        private final Class<E> elementClass;

        public StringConstructorReceiverFactory(Class<E> elementClass) {
            this.elementClass = elementClass;
        }

        @Override
        public FormReceiver<E> create() {
            return new StringConstructorReceiver<E>(this.elementClass);
        }
    }

    private static interface ElementReceiverFactory<E> {
        public FormReceiver<E> create();
    }

    private static class ConstructorReceiverFactory<E>
    implements ElementReceiverFactory<E> {
        private final Class<E> elementClass;

        public ConstructorReceiverFactory(Class<E> elementClass) {
            this.elementClass = elementClass;
        }

        @Override
        public FormReceiver<E> create() {
            return new ConstructorReceiver<E>(this.elementClass);
        }
    }
}

