/*
 * Decompiled with CFR 0.152.
 */
package ca.grimoire.formtree.receiver.constructor;

import ca.grimoire.formtree.receiver.constructor.CollectionReceiver;
import java.lang.reflect.Array;
import java.util.List;

public class ArrayReceiver<T>
extends CollectionReceiver<T, T[]> {
    public static Class<?> acceptableArrayClass(Class<?> type) {
        if (!type.isArray()) {
            return null;
        }
        return ArrayReceiver.acceptableElementClass(type.getComponentType());
    }

    public static <T> ArrayReceiver<T> create(Class<T> elementClass) {
        return new ArrayReceiver<T>(elementClass);
    }

    public ArrayReceiver(Class<T> elementClass) {
        super(elementClass);
    }

    @Override
    protected T[] createCollection(List<T> elements) {
        Object[] array = (Object[])Array.newInstance(this.elementClass, elements.size());
        return elements.toArray(array);
    }
}

