/*
 * Decompiled with CFR 0.152.
 */
package ca.grimoire.formtree;

import ca.grimoire.formtree.FormAdapter;
import ca.grimoire.formtree.FormElementReceiver;
import ca.grimoire.formtree.FormReceiver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormDecoder {
    private final Pattern LIST_KEY = Pattern.compile("([-A-Za-z_][-A-Za-z_0-9]*)\\[(\\d+)\\]");

    public <T> T decode(FormAdapter form, FormReceiver<T> receiver) {
        for (String field : form.getFields()) {
            FormElementReceiver fieldReceiver = this.findFieldReceiver(receiver, field);
            fieldReceiver.values(form.getValues(field));
        }
        return receiver.finished();
    }

    private <T> FormElementReceiver findFieldReceiver(FormReceiver<T> receiver, String field) {
        String[] path = field.split("\\.");
        FormElementReceiver fieldReceiver = receiver;
        for (String element : path) {
            fieldReceiver = this.findPathElementReceiver(element, fieldReceiver);
        }
        return fieldReceiver;
    }

    private final FormElementReceiver findPathElementReceiver(String pathElement, FormElementReceiver receiver) {
        Matcher listKeyMatcher = this.LIST_KEY.matcher(pathElement);
        if (listKeyMatcher.matches()) {
            String listName = listKeyMatcher.group(1);
            int index = Integer.parseInt(listKeyMatcher.group(2));
            return receiver.key(listName).index(index);
        }
        return receiver.key(pathElement);
    }
}

