/*
 * Decompiled with CFR 0.152.
 */
package ca.genovese.coffeecats.types;

import ca.genovese.coffeecats.util.Kind;

public interface Option<T>
extends Kind<Option, T> {
    public static <A> Option<A> create(A a) {
        if (a != null) {
            return new Some<A>(a);
        }
        return new None();
    }

    public T get();

    public T getOrElse(T var1);

    public static class Some<T>
    implements Option<T> {
        private final T t;

        public Some(T t) {
            this.t = t;
        }

        @Override
        public T get() {
            return this.t;
        }

        @Override
        public T getOrElse(T other) {
            return this.t;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Some that = (Some)o;
            return !(this.t == null ? that.t != null : !this.t.equals(that.t));
        }

        public String toString() {
            return "OptionSome{t=" + this.t + '}';
        }

        public int hashCode() {
            return this.t != null ? this.t.hashCode() : 0;
        }
    }

    public static class None<T>
    implements Option<T> {
        @Override
        public T get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T getOrElse(T other) {
            return other;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 1;
        }
    }
}

