/*
 * Decompiled with CFR 0.152.
 */
package ca.genovese.coffeecats.types;

import ca.genovese.coffeecats.util.Kind;
import java.util.Iterator;

public interface FunctionalList<T>
extends Kind<FunctionalList, T>,
Iterable<T> {
    public static <A> FunctionalList<A> create(A ... as) {
        FunctionalList list = new Nil();
        for (int i = as.length - 1; i >= 0; --i) {
            list = new Cons<A>(as[i], list);
        }
        return list;
    }

    public T getHead();

    public FunctionalList<T> getTail();

    public static final class Nil<A>
    implements FunctionalList<A> {
        @Override
        public A getHead() {
            throw new IllegalStateException("Head on an empty list");
        }

        @Override
        public FunctionalList<A> getTail() {
            throw new IllegalStateException("Tail on an empty list");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 1;
        }

        @Override
        public Iterator<A> iterator() {
            return new Iterator<A>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public A next() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static final class ListIterator<T>
    implements Iterator<T> {
        private FunctionalList<T> list;

        public ListIterator(FunctionalList<T> list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return !(this.list instanceof Nil);
        }

        @Override
        public T next() {
            T head = this.list.getHead();
            this.list = this.list.getTail();
            return head;
        }
    }

    public static class Cons<A>
    implements FunctionalList<A> {
        private final A head;
        private final FunctionalList<A> tail;

        public Cons(A head, FunctionalList<A> tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public A getHead() {
            return this.head;
        }

        @Override
        public FunctionalList<A> getTail() {
            return this.tail;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cons listItem = (Cons)o;
            if (this.head != null ? !this.head.equals(listItem.head) : listItem.head != null) {
                return false;
            }
            return !(this.tail == null ? listItem.tail != null : !this.tail.equals(listItem.tail));
        }

        public int hashCode() {
            int result = this.head != null ? this.head.hashCode() : 0;
            result = 31 * result + (this.tail != null ? this.tail.hashCode() : 0);
            return result;
        }

        public String toString() {
            Cons t = this;
            StringBuilder sb = new StringBuilder("List {");
            for (A a : this) {
                sb.append(a.toString()).append(",");
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public Iterator<A> iterator() {
            return new ListIterator(this);
        }
    }
}

