/*
 * Decompiled with CFR 0.152.
 */
package ca.genovese.coffeecats.cats.functor;

import ca.genovese.coffeecats.cats.Functor;
import ca.genovese.coffeecats.cats.functor.Contravariant;
import ca.genovese.coffeecats.util.Kind;
import java.util.function.Function;

public interface Invariant<F> {
    public <A, B> Kind<F, B> imap(Kind<F, A> var1, Function<A, B> var2, Function<B, A> var3);

    default public <G> Invariant<Kind<F, G>> compose(Invariant<G> g) {
        return new Composite(this, g);
    }

    default public <G> Invariant<Kind<F, G>> composeWithFunctor(Functor<G> g) {
        return new CovariantComposite(this, g);
    }

    default public <G> Invariant<Kind<F, G>> composeWithContravariant(Contravariant<G> g) {
        return new ContravariantComposite(this, g);
    }

    public static class ContravariantComposite<F, G>
    implements Invariant<Kind<F, G>> {
        private final Invariant<F> F;
        private final Contravariant<G> G;

        public ContravariantComposite(Invariant<F> f, Contravariant<G> g) {
            this.F = f;
            this.G = g;
        }

        @Override
        public <A, B> Kind<Kind<F, G>, B> imap(Kind<Kind<F, G>, A> fga, Function<A, B> f, Function<B, A> g) {
            return this.F.imap(fga, (A ga) -> this.G.contramap(ga, g), (B gb) -> this.G.contramap((Kind)gb, f));
        }
    }

    public static class CovariantComposite<F, G>
    implements Invariant<Kind<F, G>> {
        private final Invariant<F> F;
        private final Functor<G> G;

        public CovariantComposite(Invariant<F> f, Functor<G> g) {
            this.F = f;
            this.G = g;
        }

        @Override
        public <A, B> Kind<Kind<F, G>, B> imap(Kind<Kind<F, G>, A> fga, Function<A, B> f, Function<B, A> g) {
            return this.F.imap(fga, (A ga) -> this.G.map(ga, f), (B gb) -> this.G.map((Kind)gb, g));
        }
    }

    public static class Composite<F, G>
    implements Invariant<Kind<F, G>> {
        private final Invariant<F> F;
        private final Invariant<G> G;

        public Composite(Invariant<F> f, Invariant<G> g) {
            this.F = f;
            this.G = g;
        }

        @Override
        public <A, B> Kind<Kind<F, G>, B> imap(Kind<Kind<F, G>, A> fga, Function<A, B> f, Function<B, A> g) {
            return this.F.imap(fga, (A ga) -> this.G.imap(ga, f, g), (B gb) -> this.G.imap((Kind)gb, g, f));
        }
    }
}

