/*
 * Decompiled with CFR 0.152.
 */
package ca.genovese.coffeecats.cats.functor;

import ca.genovese.coffeecats.cats.Functor;
import ca.genovese.coffeecats.cats.functor.Invariant;
import ca.genovese.coffeecats.util.Kind;
import java.util.function.Function;

public interface Contravariant<F>
extends Invariant<F> {
    public <A, B> Kind<F, B> contramap(Kind<F, A> var1, Function<B, A> var2);

    @Override
    default public <A, B> Kind<F, B> imap(Kind<F, A> fa, Function<A, B> f, Function<B, A> g) {
        return this.contramap(fa, g);
    }

    @Override
    default public <G> Functor<Kind<F, G>> compose(Contravariant<G> g) {
        return new Composite(this, g);
    }

    @Override
    default public <G> Contravariant<Kind<F, G>> composeWithFunctor(Functor<G> g) {
        return new CovariantComposite(this, g);
    }

    public static class CovariantComposite<F, G>
    implements Contravariant<Kind<F, G>> {
        private final Contravariant<F> F;
        private final Functor<G> G;

        public CovariantComposite(Contravariant<F> f, Functor<G> g) {
            this.F = f;
            this.G = g;
        }

        @Override
        public <A, B> Kind<Kind<F, G>, B> contramap(Kind<Kind<F, G>, A> fga, Function<B, A> f) {
            return this.F.contramap(fga, (B gb) -> this.G.map(gb, f));
        }
    }

    public static class Composite<F, G>
    implements Functor<Kind<F, G>> {
        private final Contravariant<F> F;
        private final Contravariant<G> G;

        public Composite(Contravariant<F> f, Contravariant<G> g) {
            this.F = f;
            this.G = g;
        }

        @Override
        public <A, B> Kind<Kind<F, G>, B> map(Kind<Kind<F, G>, A> fga, Function<A, B> f) {
            Kind<Kind<F, G>, Kind> result = this.F.contramap(fga, gb -> this.G.contramap(gb, f));
            return result;
        }
    }
}

