/*
 * Decompiled with CFR 0.152.
 */
package ca.genovese.coffeecats.cats;

import java.util.function.Supplier;

public abstract class Lazy<A> {
    public abstract A value();

    public abstract Lazy<A> cached();

    public abstract Lazy<A> uncached();

    public static <A> Lazy<A> byNeed(Supplier<A> a) {
        return new ByNeed<A>(a);
    }

    public static <A> Lazy<A> byName(Supplier<A> a) {
        return new ByName<A>(a);
    }

    public static <A> Lazy<A> eager(Supplier<A> a) {
        return new Eager<A>(a);
    }

    public static <A> Lazy<A> eager(A a) {
        return new Eager<Object>(() -> a);
    }

    private static final class ByNeed<A>
    extends Lazy<A> {
        public final Supplier<A> f;
        public A a;

        public ByNeed(Supplier<A> a) {
            this.f = a;
        }

        @Override
        public synchronized A value() {
            if (this.a == null) {
                this.a = this.f.get();
            }
            return this.a;
        }

        @Override
        public Lazy<A> cached() {
            return this;
        }

        @Override
        public Lazy<A> uncached() {
            return new ByName<A>(this.f);
        }
    }

    private static final class ByName<A>
    extends Lazy<A> {
        public final Supplier<A> a;

        public ByName(Supplier<A> a) {
            this.a = a;
        }

        @Override
        public A value() {
            return this.a.get();
        }

        @Override
        public Lazy<A> cached() {
            return new ByNeed<A>(this.a);
        }

        @Override
        public Lazy<A> uncached() {
            return this;
        }
    }

    private static final class Eager<A>
    extends Lazy<A> {
        private final A a;

        public Eager(Supplier<A> a) {
            this.a = a.get();
        }

        @Override
        public A value() {
            return this.a;
        }

        @Override
        public Lazy<A> cached() {
            return this;
        }

        @Override
        public Lazy<A> uncached() {
            return this;
        }
    }
}

