/*
 * Decompiled with CFR 0.152.
 */
package ca.genovese.coffeecats.cats;

import ca.genovese.coffeecats.cats.functor.Invariant;
import ca.genovese.coffeecats.util.Kind;
import ca.genovese.coffeecats.util.Unit;
import ca.genovese.coffeecats.util.types.tuple.Tuple2;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Functor<F>
extends Invariant<F> {
    public <A, B> Kind<F, B> map(Kind<F, A> var1, Function<A, B> var2);

    @Override
    default public <A, B> Kind<F, B> imap(Kind<F, A> fa, Function<A, B> f, Function<B, A> g) {
        return this.map(fa, f);
    }

    default public <A, B> Function<Kind<F, A>, Kind<F, B>> lift(Function<A, B> f) {
        return fa -> this.map((Kind)fa, f);
    }

    default public <A, B> Kind<F, Tuple2<A, B>> zipWith(Kind<F, A> fa, Function<A, B> f) {
        return this.map(fa, a -> new Tuple2(a, f.apply(a)));
    }

    default public <B> Kind<F, B> as(Kind<F, ?> fa, Supplier<B> b) {
        return this.map(fa, a -> b.get());
    }

    default public Kind<F, Unit> voidMe(Kind<F, ?> fa) {
        return this.as(fa, () -> Unit.instance);
    }

    @Override
    default public <G> Functor<Kind<F, G>> compose(Functor<G> fg) {
        return new CompositeFunctor(this, fg);
    }

    public static class CompositeFunctor<F, G>
    implements Functor<Kind<F, G>> {
        private final Functor<G> fg;
        private final Functor<F> ff;

        public CompositeFunctor(Functor<F> ff, Functor<G> fg) {
            this.fg = fg;
            this.ff = ff;
        }

        @Override
        public <A, B> Kind<Kind<F, G>, B> map(Kind<Kind<F, G>, A> fg_a, Function<A, B> f) {
            return this.ff.map(fg_a, (A ga) -> this.fg.map(ga, f));
        }
    }
}

