/*
 * Decompiled with CFR 0.152.
 */
package ca.genovese.coffeecats.cats;

import ca.genovese.coffeecats.algebra.Monoid;
import ca.genovese.coffeecats.algebra.Semigroup;
import ca.genovese.coffeecats.cats.Applicative;
import ca.genovese.coffeecats.cats.Fold;
import ca.genovese.coffeecats.cats.Lazy;
import ca.genovese.coffeecats.cats.MonoidK;
import ca.genovese.coffeecats.types.Option;
import ca.genovese.coffeecats.util.Kind;
import ca.genovese.coffeecats.util.Unit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Foldable<F> {
    public <A, B> B foldLeft(Kind<F, A> var1, B var2, BiFunction<B, A, B> var3);

    public <A, B> Fold<B> partialFold(Kind<F, A> var1, Function<A, Fold<B>> var2);

    default public <A, B> Lazy<B> foldLazy(Kind<F, A> fa, Lazy<B> lb, Function<A, Fold<B>> f) {
        return Lazy.byNeed(() -> this.partialFold(fa, f).complete(lb));
    }

    default public <A, B> B foldRight(Kind<F, A> fa, B b, BiFunction<A, B, B> f) {
        return this.foldLazy(fa, Lazy.eager(b), a -> new Fold.Continue(bb -> f.apply(a, bb))).value();
    }

    default public <A> A fold(Kind<F, A> fa, Monoid<A> ma) {
        return (A)this.foldLeft(fa, ma.empty(), (acc, a) -> ma.combine(acc, a));
    }

    default public <A, B> B foldMap(Kind<F, A> fa, Function<A, B> f, Monoid<B> mb) {
        return (B)this.foldLeft(fa, mb.empty(), (b, a) -> mb.combine(b, f.apply(a)));
    }

    default public <G, A, B> Kind<G, Unit> traverse_(Kind<F, A> fa, Function<A, Kind<G, B>> f, Applicative<G> G) {
        return this.foldLeft(fa, G.pure(Unit.instance), (acc, a) -> G.map2(acc, (Kind)f.apply(a), (u, b) -> Unit.instance));
    }

    default public <G, A> Kind<G, Unit> sequence_(Kind<F, Kind<G, A>> fga, Applicative<G> G) {
        return this.traverse_(fga, Function.identity(), G);
    }

    default public <G, A> Kind<G, A> foldK(Kind<F, Kind<G, A>> fga, MonoidK<G> G) {
        Semigroup algebra = G.algebra();
        return this.fold(fga, (Monoid<A>)algebra);
    }

    default public <A> Option<A> find(Kind<F, A> fa, Predicate<A> p) {
        return this.foldLazy(fa, Lazy.eager(new Option.None()), a -> {
            if (p.test(a)) {
                return new Fold.Return<Option.Some<Object>>(new Option.Some<Object>(a));
            }
            return new Fold.Pass();
        }).value();
    }
}

