/*
 * Decompiled with CFR 0.152.
 */
package ca.genovese.coffeecats.cats;

import ca.genovese.coffeecats.cats.Apply;
import ca.genovese.coffeecats.cats.Traverse;
import ca.genovese.coffeecats.util.Kind;
import java.util.function.Function;

public interface Applicative<F>
extends Apply<F> {
    public <A> Kind<F, A> pure(A var1);

    @Override
    default public <A, B> Kind<F, B> map(Kind<F, A> fa, Function<A, B> f) {
        return this.apply(fa, this.pure(f));
    }

    @Override
    default public <G> Applicative<Kind<F, G>> compose(Applicative<G> g) {
        return new CompositeApplicative(this, g);
    }

    default public <A, G, B> Kind<Kind<F, G>, B> traverse(Kind<G, A> value, Function<A, Kind<F, B>> f, Traverse<G> g) {
        return g.traverse(value, f, this);
    }

    default public <A, G> Kind<Kind<F, G>, A> sequence(Kind<G, Kind<F, A>> as, Traverse<G> g) {
        return this.traverse(as, Function.identity(), g);
    }

    public static class CompositeApplicative<F, G>
    extends Apply.CompositeApply<F, G>
    implements Applicative<Kind<F, G>> {
        private final Applicative<G> fg;
        private final Applicative<F> ff;

        public CompositeApplicative(Applicative<F> ff, Applicative<G> fg) {
            super(ff, fg);
            this.fg = fg;
            this.ff = ff;
        }

        @Override
        public <A> Kind<Kind<F, G>, A> pure(A a) {
            return this.ff.pure(this.fg.pure(a));
        }
    }
}

