/*
 * Decompiled with CFR 0.152.
 */
package ca.genovese.coffeecats.algebra;

import ca.genovese.coffeecats.types.Option;

public interface Semigroup<A> {
    public A combine(A var1, A var2);

    default public A combineN(A a, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Repeated combining for semigroups must have n > 0");
        }
        A result = null;
        A b = a;
        A extra = a;
        if (n == 1) {
            return a;
        }
        for (int k = n; k >= 1; k >>>= 1) {
            if (k == 1) {
                result = this.combine(b, extra);
                continue;
            }
            A x = (k & 1) == 1 ? this.combine(b, a) : a;
            b = this.combine(b, b);
            extra = x;
        }
        return result;
    }

    default public Option<A> combineAllOption(Iterable<A> as) {
        Option<Object> result = new Option.None();
        for (A a : as) {
            if (result instanceof Option.None) {
                result = Option.create(a);
                continue;
            }
            result = Option.create(this.combine(result.get(), a));
        }
        return result;
    }
}

