/*
 * Decompiled with CFR 0.152.
 */
package ca.genovese.coffeecats.algebra;

import ca.genovese.coffeecats.algebra.Eq;
import ca.genovese.coffeecats.algebra.Semigroup;

public interface Monoid<A>
extends Semigroup<A> {
    public A empty();

    default public Boolean isEmpty(Eq<A> ev, A a) {
        return ev.eqv(a, this.empty());
    }

    @Override
    default public A combineN(A a, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Repeated combining for monoids must have n >= 0");
        }
        A result = this.empty();
        for (int i = n; i > 0; --i) {
            result = this.combine(result, a);
        }
        return result;
    }

    default public A combineAll(Iterable<A> as) {
        A result = this.empty();
        for (A a : as) {
            result = this.combine(result, a);
        }
        return result;
    }
}

