package ca.genovese.coffeecats.cats.syntax;

import ca.genovese.coffeecats.cats.functor.Strong;
import ca.genovese.coffeecats.util.Kind2;
import ca.genovese.coffeecats.util.types.tuple.Tuple2;

import java.util.function.Function;

public interface StrongOps<F, A, B> extends ProfunctorOps<F, A, B> {
  static <F, A, B> StrongOps<F, A, B> create(Strong<F> f, Kind2<F, A, B> fa) {
    return new StrongOps<F, A, B>() {
      @Override
      public Strong<F> F() {
        return f;
      }

      @Override
      public Kind2<F, A, B> get() {
        return fa;
      }
    };
  }

  default <C, D> StrongOps<F, C, D> createLocal(Kind2<F, C, D> fb) {
    return StrongOps.create(F(), fb);
  }

  Strong<F> F();

  Kind2<F, A, B> get();

  default<C> StrongOps<F, Tuple2<A, C>, Tuple2<B, C>> first() {
    return createLocal(F().first(get()));

  }

  default<C> StrongOps<F, Tuple2<C, A>, Tuple2<C, B>> second() {
    return createLocal(F().second(get()));
  }

  @Override
  default <C, D> StrongOps<F, C, D> dimap(Function<C, A> f, Function<B, D> g) {
    return createLocal(F().dimap(get(), f, g));
  }

  @Override
  default <C> StrongOps<F, C, B> lmap(Function<C, A> f) {
    return createLocal(F().lmap(get(), f));
  }

  @Override
  default <C> StrongOps<F, A, C> rmap(Function<B, C> f) {
    return createLocal(F().rmap(get(), f));
  }
}
