package ca.genovese.coffeecats.cats.syntax;

import ca.genovese.coffeecats.cats.arrow.Split;
import ca.genovese.coffeecats.util.Kind2;
import ca.genovese.coffeecats.util.types.tuple.Tuple2;

public interface SplitOps<F, A, B> {
  static <F, A, B> SplitOps<F, A, B> create(Split<F> f, Kind2<F, A, B> fb) {
    return new SplitOps<F, A, B>() {
      @Override
      public Split<F> F() {
        return f;
      }

      @Override
      public Kind2<F, A, B> get() {
        return fb;
      }
    };
  }

  default <C, D> SplitOps<F, C, D> createLocal(Kind2<F, C, D> fb) {
    return SplitOps.create(F(), fb);
  }

  Split<F> F();

  Kind2<F, A, B> get();

  default <C, D> SplitOps<F, Tuple2<A, C>, Tuple2<B, D>> split(Kind2<F, C, D> g) {
    return createLocal(F().split(get(), g));
  }

  default <C, D> SplitOps<F, Tuple2<A, C>, Tuple2<B, D>> split(SplitOps<F, C, D> g) {
    return split(g.get());
  }

  default <C> SplitOps<F, C, B> compose(Kind2<F, C, A> g) {
    return createLocal(F().compose(get(), g));
  }

  default <C> SplitOps<F, C, B> compose(SplitOps<F, C, A> g) {
    return compose(g.get());
  }

  default <C> SplitOps<F, A, C> andThen(SplitOps<F, B, C> g) {
    return andThen(g.get());
  }

  default <C> SplitOps<F, A, C> andThen(Kind2<F, B, C> g) {
    return createLocal(F().andThen(get(), g));
  }

}
