package ca.genovese.coffeecats.cats.syntax;

import ca.genovese.coffeecats.cats.functor.Profunctor;
import ca.genovese.coffeecats.util.Kind2;

import java.util.function.Function;

public interface ProfunctorOps<F, A, B> {
  static <F, A, B> ProfunctorOps<F, A, B> create(Profunctor<F> f, Kind2<F, A, B> fa) {
    return new ProfunctorOps<F, A, B>() {
      @Override
      public Profunctor<F> F() {
        return f;
      }

      @Override
      public Kind2<F, A, B> get() {
        return fa;
      }
    };
  }

  default <C, D> ProfunctorOps<F, C, D> createLocal(Kind2<F, C, D> fb) {
    return ProfunctorOps.create(F(), fb);
  }

  Profunctor<F> F();

  Kind2<F, A, B> get();

  default <C, D> ProfunctorOps<F, C, D> dimap(Function<C, A> f, Function<B, D> g) {
    return createLocal(F().dimap(get(), f, g));
  }

  default <C> ProfunctorOps<F, C, B> lmap(Function<C, A> f) {
    return createLocal(F().lmap(get(), f));
  }

  default <C> ProfunctorOps<F, A, C> rmap(Function<B, C> f) {
    return createLocal(F().rmap(get(), f));
  }
}
