package ca.genovese.coffeecats.cats.syntax;

import ca.genovese.coffeecats.cats.Functor;
import ca.genovese.coffeecats.cats.functor.Invariant;
import ca.genovese.coffeecats.util.Kind;
import ca.genovese.coffeecats.util.Unit;
import ca.genovese.coffeecats.util.types.tuple.Tuple2;

import java.util.function.Function;
import java.util.function.Supplier;

public interface InvariantOps<F, A> {
  static <F, B> InvariantOps<F, B> create(Invariant<F> f, Kind<F, B> fb) {
    return new InvariantOps<F, B>() {
      @Override
      public Invariant<F> F() {
        return f;
      }

      @Override
      public Kind<F, B> get() {
        return fb;
      }
    };
  }

  default <B> InvariantOps<F, B> createLocal(Kind<F, B> fb) {
    return InvariantOps.create(F(), fb);
  }

  Invariant<F> F();
  Kind<F, A> get();

  default <B> InvariantOps<F, B> imap(Function<A, B> f, Function<B, A> g) {
    return createLocal(F().imap(get(), f, g));
  }
}
