package ca.genovese.coffeecats.cats.syntax;

import ca.genovese.coffeecats.cats.Functor;
import ca.genovese.coffeecats.util.Kind;
import ca.genovese.coffeecats.util.Unit;
import ca.genovese.coffeecats.util.types.tuple.Tuple2;

import java.util.function.Function;
import java.util.function.Supplier;

public interface FunctorOps<F, A> extends InvariantOps<F, A> {
  static <F, B> FunctorOps<F, B> create(Functor<F> f, Kind<F, B> fb) {
    return new FunctorOps<F, B>() {
      @Override
      public Functor<F> F() {
        return f;
      }

      @Override
      public Kind<F, B> get() {
        return fb;
      }
    };
  }

  default <B> FunctorOps<F, B> createLocal(Kind<F, B> fb) {
    return FunctorOps.create(F(), fb);
  }

  Functor<F> F();
  Kind<F, A> get();

  default <B> FunctorOps<F, B> map(Function<A, B> f) {
    return createLocal(F().map(get(), f));
  }

  /*
   * Tuple the values in fa with the result of applying a function
   * with the value
   */
  default <B> FunctorOps<F, Tuple2<A, B>> zipWith(Function<A, B> f) {
    return createLocal(F().zipWith(get(), f));
  }

  /*
   * Replaces the `A` value in `F[A]` with the supplied value.
   */
  default <B> FunctorOps<F, B> as(Supplier<B> b) {
    return createLocal(F().as(get(), b));
  }

  /*
   * Empty the fa of the values, preserving the structure
   */
  default FunctorOps<F, Unit> voidMe() {
    return createLocal(F().voidMe(get()));
  }

  @Override
  default <B> FunctorOps<F, B> imap(Function<A, B> f, Function<B, A> g) {
    return createLocal(F().imap(get(), f, g));
  }
}
