package ca.genovese.coffeecats.cats.syntax;

import ca.genovese.coffeecats.cats.Functor;
import ca.genovese.coffeecats.cats.functor.Contravariant;
import ca.genovese.coffeecats.util.Kind;
import ca.genovese.coffeecats.util.Unit;
import ca.genovese.coffeecats.util.types.tuple.Tuple2;

import java.util.function.Function;
import java.util.function.Supplier;

public interface ContravariantOps<F, A> extends InvariantOps<F, A> {
  static <F, B> ContravariantOps<F, B> create(Contravariant<F> f, Kind<F, B> fb) {
    return new ContravariantOps<F, B>() {
      @Override
      public Contravariant<F> F() {
        return f;
      }

      @Override
      public Kind<F, B> get() {
        return fb;
      }
    };
  }

  default <B> ContravariantOps<F, B> createLocal(Kind<F, B> fb) {
    return ContravariantOps.create(F(), fb);
  }

  Contravariant<F> F();
  Kind<F, A> get();

  default <B> ContravariantOps<F, B> contramap(Function<B, A> f) {
    return createLocal(F().contramap(get(), f));
  }

  @Override
  default <B> ContravariantOps<F, B> imap(Function<A, B> f, Function<B, A> g) {
    return createLocal(F().imap(get(), f, g));
  }
}
