package ca.genovese.coffeecats.cats.syntax;

import ca.genovese.coffeecats.cats.arrow.Compose;
import ca.genovese.coffeecats.cats.functor.Invariant;
import ca.genovese.coffeecats.util.Kind;
import ca.genovese.coffeecats.util.Kind2;

import java.util.function.Function;

public interface ComposeOps<F, A, B> {
  static <F, A, B> ComposeOps<F, A, B> create(Compose<F> f, Kind2<F, A, B> fb) {
    return new ComposeOps<F, A, B>() {
      @Override
      public Compose<F> F() {
        return f;
      }

      @Override
      public Kind2<F, A, B> get() {
        return fb;
      }
    };
  }

  default <C, D> ComposeOps<F, C, D> createLocal(Kind2<F, C, D> fb) {
    return ComposeOps.create(F(), fb);
  }

  Compose<F> F();
  Kind2<F, A, B> get();

  default <C> ComposeOps<F, C, B> compose(Kind2<F, C, A> g) {
    return createLocal(F().compose(get(), g));
  }

  default <C> ComposeOps<F, C, B> compose(ComposeOps<F, C, A> g) {
    return compose(g.get());
  }

  default <C> ComposeOps<F, A, C> andThen(ComposeOps<F, B, C> g) {
    return andThen(g.get());
  }

  default <C> ComposeOps<F, A, C> andThen(Kind2<F, B, C> g) {
    return createLocal(F().andThen(get(), g));
  }

}
