package ca.genovese.coffeecats.cats.syntax;

import ca.genovese.coffeecats.cats.Apply;
import ca.genovese.coffeecats.cats.CoflatMap;
import ca.genovese.coffeecats.util.Kind;
import ca.genovese.coffeecats.util.Unit;
import ca.genovese.coffeecats.util.types.function.Function3;
import ca.genovese.coffeecats.util.types.tuple.Tuple2;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public interface CoflatMapOps<F, A> extends FunctorOps<F, A> {
  static <F, A> CoflatMapOps<F, A> create(CoflatMap<F> f, Kind<F, A> fb) {
    return new CoflatMapOps<F, A>() {
      @Override
      public CoflatMap<F> F() {
        return f;
      }

      @Override
      public Kind<F, A> get() {
        return fb;
      }
    };
  }

  default <B> CoflatMapOps<F, B> createLocal(Kind<F, B> fb) {
    return CoflatMapOps.create(F(), fb);
  }


  @Override
  CoflatMap<F> F();

  default <B> CoflatMapOps<F, B> coflatMap(Function<Kind<F, A>, B> f) {
    return createLocal(F().coflatMap(get(), f));
  }

  default CoflatMapOps<F, Kind<F, A>> coflatten() {
    return createLocal(F().coflatten(get()));
  }

  @Override
  default <B> CoflatMapOps<F, B> map(Function<A, B> f) {
    return createLocal(F().map(get(), f));
  }

  @Override
  default <B> CoflatMapOps<F, Tuple2<A, B>> zipWith(Function<A, B> f) {
    return createLocal(F().zipWith(get(), f));
  }

  @Override
  default <B> CoflatMapOps<F, B> as(Supplier<B> b) {
    return createLocal(F().as(get(), b));
  }

  @Override
  default CoflatMapOps<F, Unit> voidMe() {
    return createLocal(F().voidMe(get()));
  }

  @Override
  default <B> CoflatMapOps<F, B> imap(Function<A, B> f, Function<B, A> g) {
    return createLocal(F().imap(get(), f, g));
  }
}
