package ca.genovese.coffeecats.cats.syntax;

import ca.genovese.coffeecats.cats.arrow.Category;
import ca.genovese.coffeecats.util.Kind2;

public interface CategoryOps<F, A, B> {
  static <F, A, B> CategoryOps<F, A, B> create(Category<F> f, Kind2<F, A, B> fb) {
    return new CategoryOps<F, A, B>() {
      @Override
      public Category<F> F() {
        return f;
      }

      @Override
      public Kind2<F, A, B> get() {
        return fb;
      }
    };
  }

  static <F, A> CategoryOps<F, A, A> id(Category<F> category) {
    return create(category, category.id());
  }

  default <C, D> CategoryOps<F, C, D> createLocal(Kind2<F, C, D> fb) {
    return CategoryOps.create(F(), fb);
  }

  Category<F> F();
  Kind2<F, A, B> get();

  default <C> CategoryOps<F, C, B> compose(Kind2<F, C, A> g) {
    return createLocal(F().compose(get(), g));
  }

  default <C> CategoryOps<F, C, B> compose(CategoryOps<F, C, A> g) {
    return compose(g.get());
  }

  default <C> CategoryOps<F, A, C> andThen(CategoryOps<F, B, C> g) {
    return andThen(g.get());
  }

  default <C> CategoryOps<F, A, C> andThen(Kind2<F, B, C> g) {
    return createLocal(F().andThen(get(), g));
  }

}
