package ca.genovese.coffeecats.cats.syntax;

import ca.genovese.coffeecats.cats.functor.Bifunctor;
import ca.genovese.coffeecats.util.Kind2;

import java.util.function.Function;

public interface BifunctorOps<F, A, B> {
  static <F, A, B> BifunctorOps<F, A, B> create(Bifunctor<F> f, Kind2<F, A, B> fa) {
    return new BifunctorOps<F, A, B>() {
      @Override
      public Bifunctor<F> F() {
        return f;
      }

      @Override
      public Kind2<F, A, B> get() {
        return fa;
      }
    };
  }

  default <C, D> BifunctorOps<F, C, D> createLocal(Kind2<F, C, D> fb) {
    return BifunctorOps.create(F(), fb);
  }

  Bifunctor<F> F();

  Kind2<F, A, B> get();

  default <C, D> BifunctorOps<F, C, D> bimap(Function<A, C> f, Function<B, D> g) {
    return createLocal(F().bimap(get(), f, g));
  }
}
