package ca.genovese.coffeecats.cats.syntax;

import ca.genovese.coffeecats.cats.Applicative;
import ca.genovese.coffeecats.cats.Apply;
import ca.genovese.coffeecats.cats.Traverse;
import ca.genovese.coffeecats.util.Kind;
import ca.genovese.coffeecats.util.Unit;
import ca.genovese.coffeecats.util.types.function.Function3;
import ca.genovese.coffeecats.util.types.tuple.Tuple2;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ApplicativeOps<F, A> extends ApplyOps<F, A> {
  static <F, A> ApplicativeOps<F, A> create(Applicative<F> f, Kind<F, A> fb) {
    return new ApplicativeOps<F, A>() {
      @Override
      public Applicative<F> F() {
        return f;
      }

      @Override
      public Kind<F, A> get() {
        return fb;
      }
    };
  }

  default <B> ApplicativeOps<F, B> createLocal(Kind<F, B> fb) {
    return ApplicativeOps.create(F(), fb);
  }

  @Override
  Applicative<F> F();

  @Override
  default <B> ApplicativeOps<F, B> map(Function<A, B> f) {
    return createLocal(F().apply(get(), F().pure(f)));
  }

  static <F, A> ApplicativeOps<F, A> pure(Applicative<F> f, A a) {
    return create(f, f.pure(a));
  }

  @Override
  default <B> ApplicativeOps<F, B> apply(Kind<F, Function<A, B>> f) {
    return create(F(), F().apply(get(), f));
  }

  @Override
  default <B, Z> ApplicativeOps<F, Z> apply2(Kind<F, B> fb, Kind<F, BiFunction<A, B, Z>> ff) {
    return createLocal(F().apply2(get(), fb, ff));
  }


  @Override
  default <B, Z> ApplicativeOps<F, Z> map2(Kind<F, A> fa, Kind<F, B> fb, BiFunction<A, B, Z> f) {
    return createLocal(F().map2(get(), fb, f));
  }

  @Override
  default <B, C, Z> ApplicativeOps<F, Z> map3(Kind<F, B> fb, Kind<F, C> fc, Function3<A, B, C, Z> f) {
    return createLocal(F().map3(get(), fb, fc, f));
  }

  @Override
  default <B> ApplicativeOps<F, Tuple2<A, B>> zipWith(Function<A, B> f) {
    return createLocal(F().zipWith(get(), f));
  }

  @Override
  default <B> ApplicativeOps<F, B> as(Supplier<B> b) {
    return createLocal(F().as(get(), b));
  }

  @Override
  default ApplicativeOps<F, Unit> voidMe() {
    return createLocal(F().voidMe(get()));
  }

  @Override
  default <B> ApplicativeOps<F, B> imap(Function<A, B> f, Function<B, A> g) {
    return createLocal(F().imap(get(), f, g));
  }
}
