/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.worker;

import ca.eandb.jdcp.job.JobExecutionException;
import ca.eandb.jdcp.job.ParallelizableJob;
import ca.eandb.jdcp.job.TaskDescription;
import ca.eandb.jdcp.job.TaskWorker;
import ca.eandb.jdcp.remote.JobService;
import ca.eandb.jdcp.remote.JobStatus;
import ca.eandb.jdcp.remote.TaskService;
import ca.eandb.jdcp.worker.JobServiceFactory;
import ca.eandb.util.rmi.Serialized;
import java.io.EOFException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.util.BitSet;
import java.util.UUID;
import org.apache.log4j.Logger;

public final class ReconnectingJobService
implements JobService {
    private static final Logger logger = Logger.getLogger(ReconnectingJobService.class);
    private final JobServiceFactory factory;
    private JobService service;

    public ReconnectingJobService(JobServiceFactory factory) {
        this.factory = factory;
    }

    private synchronized JobService getJobService(JobService oldService) {
        if (this.service == oldService) {
            this.service = this.factory.connect();
        }
        return this.service;
    }

    public void cancelJob(UUID jobId) throws IllegalArgumentException, SecurityException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                service.cancelJob(jobId);
                return;
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public UUID createJob(String description) throws SecurityException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                return service.createJob(description);
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public byte[] getClassDefinition(String name, UUID jobId) throws SecurityException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                return service.getClassDefinition(name, jobId);
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public byte[] getClassDigest(String name, UUID jobId) throws SecurityException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                return service.getClassDigest(name, jobId);
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public byte[] getClassDigest(String name) throws SecurityException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                return service.getClassDigest(name);
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public Serialized<TaskWorker> getTaskWorker(UUID jobId) throws IllegalArgumentException, SecurityException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                return service.getTaskWorker(jobId);
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void reportException(UUID jobId, int taskId, Exception e) throws SecurityException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                service.reportException(jobId, taskId, e);
                return;
            }
            catch (RemoteException e1) {
                logger.error((Object)"Lost connection", (Throwable)e1);
                continue;
            }
            break;
        }
    }

    public TaskDescription requestTask() throws SecurityException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                return service.requestTask();
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void setClassDefinition(String name, byte[] def) throws SecurityException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                service.setClassDefinition(name, def);
                return;
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void setClassDefinition(String name, UUID jobId, byte[] def) throws IllegalArgumentException, SecurityException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                service.setClassDefinition(name, jobId, def);
                return;
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void setIdleTime(int idleSeconds) throws IllegalArgumentException, SecurityException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                service.setIdleTime(idleSeconds);
                return;
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void setJobPriority(UUID jobId, int priority) throws IllegalArgumentException, SecurityException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                service.setJobPriority(jobId, priority);
                return;
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void submitJob(Serialized<ParallelizableJob> job, UUID jobId) throws IllegalArgumentException, SecurityException, ClassNotFoundException, JobExecutionException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                service.submitJob(job, jobId);
                return;
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public UUID submitJob(Serialized<ParallelizableJob> job, String description) throws SecurityException, ClassNotFoundException, JobExecutionException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                return service.submitJob(job, description);
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void submitTaskResults(UUID jobId, int taskId, Serialized<Object> results) throws SecurityException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                service.submitTaskResults(jobId, taskId, results);
                return;
            }
            catch (RemoteException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public BitSet getFinishedTasks(UUID[] jobIds, int[] taskIds) throws IllegalArgumentException, SecurityException, RemoteException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                return service.getFinishedTasks(jobIds, taskIds);
            }
            catch (NoSuchObjectException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (ConnectException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (ConnectIOException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (UnknownHostException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (UnmarshalException e) {
                if (e.getCause() instanceof EOFException) {
                    logger.error((Object)"Lost connection", (Throwable)e);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public void registerTaskService(String name, TaskService taskService) throws SecurityException, RemoteException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                service.registerTaskService(name, taskService);
                return;
            }
            catch (NoSuchObjectException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (ConnectException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (ConnectIOException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (UnknownHostException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (UnmarshalException e) {
                if (e.getCause() instanceof EOFException) {
                    logger.error((Object)"Lost connection", (Throwable)e);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public void unregisterTaskService(String name) throws IllegalArgumentException, SecurityException, RemoteException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                service.unregisterTaskService(name);
                return;
            }
            catch (NoSuchObjectException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (ConnectException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (ConnectIOException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (UnknownHostException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (UnmarshalException e) {
                if (e.getCause() instanceof EOFException) {
                    logger.error((Object)"Lost connection", (Throwable)e);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public JobStatus waitForJobStatusChange(long lastEventId, long timeoutMillis) throws SecurityException, RemoteException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                return service.waitForJobStatusChange(lastEventId, timeoutMillis);
            }
            catch (NoSuchObjectException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (ConnectException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (ConnectIOException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (UnknownHostException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (UnmarshalException e) {
                if (e.getCause() instanceof EOFException) {
                    logger.error((Object)"Lost connection", (Throwable)e);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public JobStatus waitForJobStatusChange(UUID jobId, long lastEventId, long timeoutMillis) throws IllegalArgumentException, SecurityException, RemoteException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                return service.waitForJobStatusChange(jobId, lastEventId, timeoutMillis);
            }
            catch (NoSuchObjectException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (ConnectException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (ConnectIOException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (UnknownHostException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (UnmarshalException e) {
                if (e.getCause() instanceof EOFException) {
                    logger.error((Object)"Lost connection", (Throwable)e);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public JobStatus getJobStatus(UUID jobId) throws IllegalArgumentException, SecurityException, RemoteException {
        JobService service = null;
        while (true) {
            try {
                service = this.getJobService(service);
                return service.getJobStatus(jobId);
            }
            catch (NoSuchObjectException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (ConnectException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (ConnectIOException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (UnknownHostException e) {
                logger.error((Object)"Lost connection", (Throwable)e);
                continue;
            }
            catch (UnmarshalException e) {
                if (e.getCause() instanceof EOFException) {
                    logger.error((Object)"Lost connection", (Throwable)e);
                    continue;
                }
                throw e;
            }
            break;
        }
    }
}

