/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.worker;

import ca.eandb.jdcp.remote.TaskService;
import ca.eandb.util.classloader.ClassLoaderStrategy;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.util.UUID;

public final class JobServiceClassLoaderStrategy
implements ClassLoaderStrategy {
    private final TaskService service;
    private final UUID jobId;

    public JobServiceClassLoaderStrategy(TaskService service, UUID jobId) {
        this.service = service;
        this.jobId = jobId;
    }

    public ByteBuffer getClassDefinition(String name) {
        try {
            byte[] def = this.service.getClassDefinition(name, this.jobId);
            if (def != null) {
                return ByteBuffer.wrap(def);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }
}

