/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.worker;

import ca.eandb.jdcp.remote.JobService;
import ca.eandb.jdcp.remote.TaskService;
import ca.eandb.jdcp.worker.CachingJobServiceClassLoaderStrategy;
import ca.eandb.util.StringUtil;
import ca.eandb.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.log4j.Logger;

public final class FileCachingJobServiceClassLoaderStrategy
extends CachingJobServiceClassLoaderStrategy {
    private static final Logger logger = Logger.getLogger(FileCachingJobServiceClassLoaderStrategy.class);
    private final File directory;

    public FileCachingJobServiceClassLoaderStrategy(TaskService service, UUID jobId, File directory) {
        super(service, jobId);
        this.directory = directory;
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory must be a directory.");
        }
    }

    public FileCachingJobServiceClassLoaderStrategy(JobService service, UUID jobId, String directory) {
        this((TaskService)service, jobId, new File(directory));
    }

    @Override
    protected byte[] cacheLookup(String name, byte[] digest) {
        File file = this.getCacheEntryFile(name, digest, false);
        byte[] def = null;
        if (file.exists()) {
            try {
                def = FileUtil.getFileContents((File)file);
            }
            catch (IOException e) {
                logger.error((Object)"Could not read class definition file", (Throwable)e);
                def = null;
            }
        }
        return def;
    }

    @Override
    protected void cacheStore(String name, byte[] digest, byte[] def) {
        File file = this.getCacheEntryFile(name, digest, true);
        try {
            FileUtil.setFileContents((File)file, (byte[])def);
        }
        catch (IOException e) {
            logger.error((Object)"Could not write class definition file", (Throwable)e);
        }
    }

    private File getCacheEntryFile(String name, byte[] digest, boolean createDirectory) {
        File entryDirectory = new File(this.directory, name.replace('.', '/'));
        if (createDirectory && !entryDirectory.isDirectory()) {
            entryDirectory.mkdirs();
        }
        return new File(entryDirectory, StringUtil.toHex((byte[])digest));
    }
}

