/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.worker;

import ca.eandb.jdcp.remote.TaskService;
import ca.eandb.jdcp.worker.CachingJobServiceClassLoaderStrategy;
import ca.eandb.util.StringUtil;
import ca.eandb.util.sql.DbUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public final class DbCachingJobServiceClassLoaderStrategy
extends CachingJobServiceClassLoaderStrategy {
    private static final Logger logger = Logger.getLogger(DbCachingJobServiceClassLoaderStrategy.class);
    private final DataSource ds;

    public static void prepareDataSource(DataSource ds) throws SQLException {
        Connection con = null;
        try {
            con = ds.getConnection();
            con.setAutoCommit(false);
            DatabaseMetaData meta = con.getMetaData();
            ResultSet rs = meta.getTables(null, null, null, new String[]{"TABLE"});
            int tableNameColumn = rs.findColumn("TABLE_NAME");
            int count = 0;
            while (rs.next()) {
                String tableName = rs.getString(tableNameColumn);
                if (!tableName.equalsIgnoreCase("CachedClasses")) continue;
                ++count;
            }
            if (count == 0) {
                String blobType = DbUtil.getTypeName((int)2004, (Connection)con);
                String nameType = DbUtil.getTypeName((int)12, (int)1024, (Connection)con);
                String md5Type = DbUtil.getTypeName((int)-2, (int)16, (Connection)con);
                String sql = "CREATE TABLE CachedClasses ( \n  Name " + nameType + " NOT NULL, \n  MD5 " + md5Type + " NOT NULL, \n  Definition " + blobType + " NOT NULL, \n  PRIMARY KEY (Name, MD5) \n)";
                DbUtil.update((DataSource)ds, (String)sql, (Object[])new Object[0]);
                con.commit();
            }
            con.setAutoCommit(true);
        }
        catch (SQLException e) {
            DbUtil.rollback((Connection)con);
            throw e;
        }
        finally {
            DbUtil.close((Connection)con);
        }
    }

    public DbCachingJobServiceClassLoaderStrategy(TaskService service, UUID jobId, DataSource ds) {
        super(service, jobId);
        this.ds = ds;
    }

    @Override
    protected byte[] cacheLookup(String name, byte[] digest) {
        String sql = "SELECT Definition FROM CachedClasses WHERE Name = ?   AND MD5 = ?";
        try {
            return DbUtil.queryBinary((DataSource)this.ds, null, (String)sql, (Object[])new Object[]{name, digest});
        }
        catch (SQLException e) {
            logger.error((Object)"Database error", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void cacheStore(String name, byte[] digest, byte[] def) {
        try {
            String sql = "SELECT COUNT(1) FROM CachedClasses WHERE Name = ?   AND MD5 = ?";
            if (DbUtil.queryInt((DataSource)this.ds, (int)0, (String)sql, (Object[])new Object[]{name, digest}) > 0) {
                String message = String.format("Overwriting class definition: name='%s', digest=%s", name, StringUtil.toHex((byte[])digest));
                logger.warn((Object)message);
                DbUtil.update((DataSource)this.ds, (String)"UPDATE CachedClasses SET Definition = ? WHERE Name = ?   AND MD5 = ?", (Object[])new Object[]{def, name, digest});
            } else {
                DbUtil.update((DataSource)this.ds, (String)"INSERT INTO CachedClasses   (Name, MD5, Definition) VALUES   (?, ?, ?)", (Object[])new Object[]{name, digest, def});
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Database error", (Throwable)e);
        }
    }
}

