/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.worker;

import ca.eandb.jdcp.remote.JobService;
import ca.eandb.jdcp.remote.TaskService;
import ca.eandb.jdcp.worker.CachingJobServiceClassLoaderStrategy;
import ca.eandb.util.StringUtil;
import ca.eandb.util.UnexpectedException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public final class PersistenceCachingJobServiceClassLoaderStrategy
extends CachingJobServiceClassLoaderStrategy {
    private final URL baseUrl;
    private final PersistenceService persistenceService;

    public PersistenceCachingJobServiceClassLoaderStrategy(TaskService service, UUID jobId) throws UnavailableServiceException {
        super(service, jobId);
        BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
        this.baseUrl = basicService.getCodeBase();
        this.persistenceService = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
    }

    public PersistenceCachingJobServiceClassLoaderStrategy(JobService service, UUID jobId, URL baseUrl) throws UnavailableServiceException {
        super((TaskService)service, jobId);
        this.baseUrl = baseUrl;
        this.persistenceService = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
    }

    @Override
    protected byte[] cacheLookup(String name, byte[] digest) {
        try {
            URL url = this.getUrlForCacheEntry(name, digest);
            FileContents contents = this.persistenceService.get(url);
            InputStream in = contents.getInputStream();
            byte[] def = new byte[(int)contents.getLength()];
            in.read(def);
            return def;
        }
        catch (FileNotFoundException e) {
        }
        catch (MalformedURLException e) {
            throw new UnexpectedException((Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected void cacheStore(String name, byte[] digest, byte[] def) {
        URL url = this.getUrlForCacheEntry(name, digest);
        this.write(url, def);
    }

    private URL getUrlForCacheEntry(String name, byte[] digest) {
        try {
            return new URL(this.baseUrl, name.replace('.', '/') + StringUtil.toHex((byte[])digest));
        }
        catch (MalformedURLException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    private void write(URL url, byte[] data) {
        try {
            if (this.persistenceService.create(url, (long)data.length) < (long)data.length) {
                this.persistenceService.delete(url);
                throw new RuntimeException("Could not allocate enough space in persistence store.");
            }
            FileContents contents = this.persistenceService.get(url);
            OutputStream out = contents.getOutputStream(true);
            out.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not write data to persistence store.", e);
        }
    }
}

