/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.worker.policy.win32;

import ca.eandb.jdcp.worker.policy.AsyncCourtesyMonitor;
import ca.eandb.jdcp.worker.policy.PowerCourtesyMonitor;
import ca.eandb.jdcp.worker.policy.win32.Kernel32;
import ca.eandb.jdcp.worker.policy.win32.User32;
import ca.eandb.jdcp.worker.policy.win32.W32API;
import ca.eandb.util.UnexpectedException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.awt.Window;
import javax.swing.JWindow;

public final class Win32PowerCourtesyMonitor
extends AsyncCourtesyMonitor
implements PowerCourtesyMonitor {
    private boolean requireAC = true;
    private int minBatteryLifePercent = 0;
    private int minBatteryLifePercentWhileCharging = 0;
    private final PowerBroadcastMonitor monitor;

    public Win32PowerCourtesyMonitor() {
        if (!Platform.isWindows()) {
            throw new UnexpectedException("This class requires Windows");
        }
        this.monitor = new PowerBroadcastMonitor();
        this.update();
    }

    @Override
    public final synchronized boolean isRequireAC() {
        return this.requireAC;
    }

    @Override
    public final synchronized void setRequireAC(boolean requireAC) {
        this.requireAC = requireAC;
    }

    @Override
    public final synchronized int getMinBatteryLifePercent() {
        return this.minBatteryLifePercent;
    }

    @Override
    public final synchronized void setMinBatteryLifePercent(int minBatteryLifePercent) {
        this.minBatteryLifePercent = minBatteryLifePercent;
    }

    @Override
    public final synchronized int getMinBatteryLifePercentWhileCharging() {
        return this.minBatteryLifePercentWhileCharging;
    }

    @Override
    public final synchronized void setMinBatteryLifePercentWhileCharging(int minBatteryLifePercentWhileCharging) {
        this.minBatteryLifePercentWhileCharging = minBatteryLifePercentWhileCharging;
    }

    @Override
    public synchronized void update() {
        Kernel32.SYSTEM_POWER_STATUS status = new Kernel32.SYSTEM_POWER_STATUS();
        Kernel32.INSTANCE.GetSystemPowerStatus(status);
        switch (status.ACLineStatus) {
            case 0: {
                this.allow(!this.requireAC && (status.BatteryLifePercent < 0 || status.BatteryLifePercent >= this.minBatteryLifePercent));
                break;
            }
            default: {
                this.allow((status.BatteryFlag & 8) == 0 || status.BatteryLifePercent < 0 || status.BatteryLifePercent >= this.minBatteryLifePercentWhileCharging);
            }
        }
    }

    private final class PowerBroadcastMonitor
    implements User32.WindowProc {
        private final Window msgWindow = new JWindow();
        private final int prevWndProc;

        public PowerBroadcastMonitor() {
            this.msgWindow.setVisible(true);
            this.msgWindow.setVisible(false);
            W32API.HWND hwnd = new W32API.HWND();
            hwnd.setPointer(Native.getWindowPointer((Window)this.msgWindow));
            this.prevWndProc = User32.INSTANCE.SetWindowLong(hwnd, -4, this);
        }

        @Override
        public W32API.LRESULT callback(W32API.HWND hWnd, int uMsg, W32API.WPARAM wParam, W32API.LPARAM lParam) {
            if (uMsg == 536 && wParam.intValue() == 10) {
                Win32PowerCourtesyMonitor.this.update();
            }
            return User32.INSTANCE.CallWindowProc(this.prevWndProc, hWnd, uMsg, wParam, lParam);
        }
    }
}

