/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.worker.policy;

import ca.eandb.jdcp.worker.policy.AsyncCourtesyMonitor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class PollingCourtesyMonitor
extends AsyncCourtesyMonitor {
    private static final int CORE_THREAD_POOL_SIZE = 2;
    private static final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private ScheduledFuture<?> future = null;
    private final Runnable poll = new Runnable(){

        @Override
        public void run() {
            PollingCourtesyMonitor.this.allow(PollingCourtesyMonitor.this.poll());
        }
    };

    public synchronized void stopPolling() {
        this.future.cancel(true);
        this.allow();
    }

    public synchronized void startPolling(long initialDelay, long period, TimeUnit unit) {
        if (this.future != null) {
            this.stopPolling();
        }
        executor.scheduleAtFixedRate(this.poll, initialDelay, period, unit);
    }

    public void startPolling(long period, TimeUnit unit) {
        this.startPolling(0L, period, unit);
    }

    protected abstract boolean poll();
}

