/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.worker.policy;

import ca.eandb.jdcp.worker.policy.PollingCourtesyMonitor;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public final class ExecCourtesyMonitor
extends PollingCourtesyMonitor {
    private static final Logger logger = Logger.getLogger(ExecCourtesyMonitor.class);
    private final String command;
    private final File workingDirectory;

    public ExecCourtesyMonitor(String command) {
        this(command, null);
    }

    public ExecCourtesyMonitor(String command, File workingDirectory) {
        this.command = command;
        this.workingDirectory = workingDirectory;
    }

    @Override
    public boolean poll() {
        try {
            Process process = Runtime.getRuntime().exec(this.command, null, this.workingDirectory);
            while (true) {
                try {
                    return process.waitFor() == 0;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not execute courtesy script", (Throwable)e);
            return true;
        }
    }
}

