/*
 * Decompiled with CFR 0.152.
 */
package ca.eandb.jdcp.worker;

import ca.eandb.jdcp.job.TaskDescription;
import ca.eandb.jdcp.job.TaskWorker;
import ca.eandb.jdcp.remote.DelegationException;
import ca.eandb.jdcp.remote.TaskService;
import ca.eandb.jdcp.worker.CachingJobServiceClassLoaderStrategy;
import ca.eandb.jdcp.worker.DbCachingJobServiceClassLoaderStrategy;
import ca.eandb.jdcp.worker.InternalCachingJobServiceClassLoaderStrategy;
import ca.eandb.jdcp.worker.JobServiceFactory;
import ca.eandb.jdcp.worker.ReconnectingJobService;
import ca.eandb.jdcp.worker.policy.CourtesyMonitor;
import ca.eandb.jdcp.worker.policy.UnconditionalCourtesyMonitor;
import ca.eandb.util.UnexpectedException;
import ca.eandb.util.classloader.ClassLoaderStrategy;
import ca.eandb.util.classloader.StrategyClassLoader;
import ca.eandb.util.progress.CancelListener;
import ca.eandb.util.progress.CompositeCancelListener;
import ca.eandb.util.progress.ProgressMonitor;
import ca.eandb.util.progress.ProgressMonitorFactory;
import ca.eandb.util.rmi.Serialized;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public final class ThreadServiceWorker
implements Runnable {
    private final Map<UUID, TaskWorkerRef> workerMap = Collections.synchronizedMap(new HashMap());
    private static final Logger logger = Logger.getLogger(ThreadServiceWorker.class);
    private static final String DEFAULT_IDLE_MESSAGE = "Idling...";
    private static final String EXCEPTION_IDLE_MESSAGE = "Exception thrown, idling...";
    private static int EXCEPTION_IDLE_SECONDS = 10;
    private final Executor executor;
    private final ProgressMonitorFactory monitorFactory;
    private final CourtesyMonitor courtesyMonitor;
    private final ReconnectingJobService service;
    private Thread runThread = null;
    private boolean shutdownPending = false;
    private int maxWorkers;
    private int numWorkers;
    private final BlockingQueue<Worker> workerQueue = new LinkedBlockingQueue<Worker>();
    private DataSource dataSource = null;
    private final Lock idleLock = new ReentrantLock();
    private final Condition idleComplete = this.idleLock.newCondition();
    private boolean idling = false;
    private int poller = -1;
    private final Set<Worker> activeWorkers = Collections.synchronizedSet(new HashSet());
    private final long finishedTaskPollingInterval = 10000L;

    public ThreadServiceWorker(JobServiceFactory serviceFactory, ThreadFactory threadFactory, ProgressMonitorFactory monitorFactory, CourtesyMonitor courtesyMonitor) {
        assert (this.maxWorkers > 0);
        this.service = new ReconnectingJobService(serviceFactory);
        this.executor = Executors.newCachedThreadPool(threadFactory);
        this.maxWorkers = Runtime.getRuntime().availableProcessors();
        this.monitorFactory = monitorFactory;
        this.courtesyMonitor = courtesyMonitor;
    }

    public ThreadServiceWorker(JobServiceFactory serviceFactory, ThreadFactory threadFactory, ProgressMonitorFactory monitorFactory) {
        this(serviceFactory, threadFactory, monitorFactory, new UnconditionalCourtesyMonitor());
    }

    public void setDataSource(DataSource dataSource) throws SQLException {
        DbCachingJobServiceClassLoaderStrategy.prepareDataSource(dataSource);
        this.dataSource = dataSource;
    }

    @Override
    public synchronized void run() {
        this.runThread = Thread.currentThread();
        FinishedTaskPoller poller = new FinishedTaskPoller();
        this.executor.execute(poller);
        while (!this.shutdownPending) {
            try {
                Worker worker = this.getWorker();
                this.executor.execute(worker);
            }
            catch (InterruptedException interruptedException) {}
        }
        poller.shutdown();
        this.runThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Thread thread = this.runThread;
        synchronized (thread) {
            if (this.runThread != null && !this.shutdownPending) {
                this.shutdownPending = true;
                this.runThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxWorkers(int maxWorkers) {
        BlockingQueue<Worker> blockingQueue = this.workerQueue;
        synchronized (blockingQueue) {
            this.idleLock.lock();
            try {
                int oldMaxWorkers = this.maxWorkers;
                this.maxWorkers = maxWorkers;
                if (maxWorkers < oldMaxWorkers) {
                    this.idleComplete.signalAll();
                }
            }
            finally {
                this.idleLock.unlock();
            }
            while (this.numWorkers < maxWorkers) {
                String title = String.format("Worker (%d)", this.numWorkers + 1);
                ProgressMonitorWrapper monitor = new ProgressMonitorWrapper(this.numWorkers++, this.monitorFactory.createProgressMonitor(title));
                this.workerQueue.add(new Worker(monitor));
            }
        }
    }

    private Worker getWorker() throws InterruptedException {
        while (!this.courtesyMonitor.allowTasksToRun()) {
            this.courtesyMonitor.waitFor();
        }
        while (this.numWorkers > this.maxWorkers) {
            this.workerQueue.take();
            --this.numWorkers;
        }
        return this.workerQueue.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskWorker getTaskWorker(UUID jobId) throws ClassNotFoundException {
        TaskWorkerRef ref;
        Object object = this.workerMap;
        synchronized (object) {
            ref = this.workerMap.get(jobId);
            if (ref == null) {
                ref = new TaskWorkerRef();
                this.workerMap.put(jobId, ref);
            }
        }
        object = ref;
        synchronized (object) {
            if (ref.worker == null) {
                Serialized<TaskWorker> envelope = this.service.getTaskWorker(jobId);
                CachingJobServiceClassLoaderStrategy strategy = this.dataSource != null ? new DbCachingJobServiceClassLoaderStrategy((TaskService)this.service, jobId, this.dataSource) : new InternalCachingJobServiceClassLoaderStrategy((TaskService)this.service, jobId);
                StrategyClassLoader loader = new StrategyClassLoader((ClassLoaderStrategy)strategy, ThreadServiceWorker.class.getClassLoader());
                ref.worker = (TaskWorker)envelope.deserialize((ClassLoader)loader);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("Got worker (thread=%d)", Thread.currentThread().getId()));
                }
            }
        }
        assert (ref.worker != null);
        return ref.worker;
    }

    private class ProgressMonitorWrapper
    implements ProgressMonitor {
        private final ProgressMonitor monitor;
        private final int workerId;
        private boolean cancelPending = false;
        private CompositeCancelListener cancelListeners = new CompositeCancelListener();

        public ProgressMonitorWrapper(int workerId, ProgressMonitor monitor) {
            this.workerId = workerId;
            this.monitor = monitor;
            monitor.addCancelListener((CancelListener)this.cancelListeners);
        }

        private void waitForCourtesyMonitor() {
            if (!ThreadServiceWorker.this.courtesyMonitor.allowTasksToRun()) {
                this.monitor.notifyStatusChanged("Suspended");
                do {
                    try {
                        ThreadServiceWorker.this.courtesyMonitor.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!ThreadServiceWorker.this.courtesyMonitor.allowTasksToRun());
                this.monitor.notifyStatusChanged("Resumed");
            }
        }

        public void reset() {
            this.cancelPending = false;
        }

        public void cancel() {
            this.cancelPending = true;
            this.cancelListeners.cancelRequested();
        }

        public boolean isWorkerShutdownPending() {
            return ThreadServiceWorker.this.shutdownPending || this.workerId >= ThreadServiceWorker.this.maxWorkers;
        }

        public boolean isCancelPending() {
            return this.isLocalCancelPending() || this.monitor.isCancelPending();
        }

        public void addCancelListener(CancelListener listener) {
            this.cancelListeners.addCancelListener(listener);
        }

        private boolean isLocalCancelPending() {
            return this.cancelPending || this.isWorkerShutdownPending();
        }

        public void notifyCancelled() {
            if (this.isWorkerShutdownPending()) {
                this.monitor.notifyCancelled();
            }
        }

        public void notifyComplete() {
            if (this.isWorkerShutdownPending()) {
                this.monitor.notifyComplete();
            }
        }

        public boolean notifyIndeterminantProgress() {
            this.waitForCourtesyMonitor();
            return this.monitor.notifyIndeterminantProgress() && !this.isLocalCancelPending();
        }

        public boolean notifyProgress(int value, int maximum) {
            this.waitForCourtesyMonitor();
            return this.monitor.notifyProgress(value, maximum) && !this.isLocalCancelPending();
        }

        public boolean notifyProgress(double progress) {
            this.waitForCourtesyMonitor();
            return this.monitor.notifyProgress(progress) && !this.isLocalCancelPending();
        }

        public void notifyStatusChanged(String status) {
            this.waitForCourtesyMonitor();
            this.monitor.notifyStatusChanged(status);
        }
    }

    private class Worker
    implements Runnable {
        private final ProgressMonitorWrapper monitor;
        private UUID currentJobId = null;
        private int currentTaskId = 0;

        public Worker(ProgressMonitorWrapper monitor) {
            this.monitor = monitor;
        }

        public void cancel(UUID jobId, int taskId) {
            if (jobId == this.currentJobId && taskId == this.currentTaskId) {
                this.monitor.cancel();
            }
        }

        public UUID getCurrentJobId() {
            return this.currentJobId;
        }

        public int getCurrentTaskId() {
            return this.currentTaskId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: {
                try {
                    this.monitor.reset();
                    this.monitor.notifyIndeterminantProgress();
                    this.monitor.notifyStatusChanged("Requesting task...");
                    if (ThreadServiceWorker.this.service == null) break block17;
                    if (!this.idleWait()) {
                        return;
                    }
                    TaskDescription taskDesc = ThreadServiceWorker.this.service.requestTask();
                    UUID jobId = taskDesc.getJobId();
                    int taskId = taskDesc.getTaskId();
                    if (jobId != null) {
                        Object results;
                        TaskWorker worker;
                        this.idleEnd();
                        this.currentJobId = jobId;
                        this.currentTaskId = taskId;
                        ThreadServiceWorker.this.activeWorkers.add(this);
                        this.monitor.notifyStatusChanged("Obtaining task worker...");
                        try {
                            worker = ThreadServiceWorker.this.getTaskWorker(jobId);
                        }
                        catch (DelegationException e) {
                            worker = null;
                        }
                        catch (ClassNotFoundException e) {
                            ThreadServiceWorker.this.service.reportException(jobId, 0, e);
                            this.idle(EXCEPTION_IDLE_SECONDS, ThreadServiceWorker.EXCEPTION_IDLE_MESSAGE);
                            worker = null;
                        }
                        if (worker == null) {
                            this.monitor.notifyStatusChanged("Could not obtain worker...");
                            this.monitor.notifyCancelled();
                            return;
                        }
                        this.monitor.notifyStatusChanged("Performing task...");
                        ClassLoader loader = worker.getClass().getClassLoader();
                        try {
                            Object task = taskDesc.getTask().deserialize(loader);
                            results = worker.performTask(task, (ProgressMonitor)this.monitor);
                        }
                        catch (DelegationException e) {
                            results = null;
                        }
                        catch (Exception e) {
                            ThreadServiceWorker.this.service.reportException(jobId, taskId, e);
                            this.idle(EXCEPTION_IDLE_SECONDS, ThreadServiceWorker.EXCEPTION_IDLE_MESSAGE);
                            results = null;
                        }
                        if (results != null && !this.monitor.isCancelPending()) {
                            this.monitor.notifyStatusChanged("Submitting task results...");
                            ThreadServiceWorker.this.service.submitTaskResults(jobId, taskId, (Serialized<Object>)new Serialized(results));
                        }
                        break block17;
                    }
                    if (!this.idleBegin()) break block17;
                    try {
                        int seconds = (Integer)taskDesc.getTask().deserialize();
                        this.idle(seconds);
                    }
                    catch (ClassNotFoundException e) {
                        throw new UnexpectedException((Throwable)e);
                    }
                }
                finally {
                    this.monitor.notifyComplete();
                    ThreadServiceWorker.this.activeWorkers.remove(this);
                    this.currentJobId = null;
                    this.currentTaskId = 0;
                    ThreadServiceWorker.this.workerQueue.add(this);
                }
            }
        }

        private boolean idleBegin() {
            ThreadServiceWorker.this.idleLock.lock();
            if (!ThreadServiceWorker.this.idling) {
                ThreadServiceWorker.this.idling = true;
                ThreadServiceWorker.this.poller = this.monitor.workerId;
            }
            ThreadServiceWorker.this.idleLock.unlock();
            return ThreadServiceWorker.this.poller == this.monitor.workerId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void idleEnd() {
            if (ThreadServiceWorker.this.poller == this.monitor.workerId) {
                ThreadServiceWorker.this.idleLock.lock();
                try {
                    ThreadServiceWorker.this.idling = false;
                    ThreadServiceWorker.this.poller = -1;
                    ThreadServiceWorker.this.idleComplete.signalAll();
                }
                finally {
                    ThreadServiceWorker.this.idleLock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean idleWait() {
            block8: {
                ThreadServiceWorker.this.idleLock.lock();
                try {
                    if (!ThreadServiceWorker.this.idling || ThreadServiceWorker.this.poller == this.monitor.workerId) break block8;
                    this.monitor.notifyStatusChanged("Waiting...");
                    do {
                        if (!this.monitor.notifyIndeterminantProgress()) {
                            boolean bl = false;
                            return bl;
                        }
                        try {
                            ThreadServiceWorker.this.idleComplete.await();
                            if (!ThreadServiceWorker.this.idling || ThreadServiceWorker.this.poller < ThreadServiceWorker.this.maxWorkers || this.monitor.workerId >= ThreadServiceWorker.this.maxWorkers) continue;
                            ThreadServiceWorker.this.poller = this.monitor.workerId;
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (ThreadServiceWorker.this.idling);
                }
                finally {
                    ThreadServiceWorker.this.idleLock.unlock();
                }
            }
            return true;
        }

        private void idle(int seconds) {
            this.idle(seconds, ThreadServiceWorker.DEFAULT_IDLE_MESSAGE);
        }

        private void idle(int seconds, String message) {
            this.monitor.notifyStatusChanged(message);
            for (int i = 0; i < seconds; ++i) {
                if (!this.monitor.notifyProgress(i, seconds)) {
                    this.monitor.notifyCancelled();
                    return;
                }
                this.sleep();
            }
            this.monitor.notifyProgress(seconds, seconds);
            this.monitor.notifyComplete();
        }

        private void sleep() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Thread was interrupted", (Throwable)e);
            }
        }
    }

    private static class TaskWorkerRef {
        public TaskWorker worker;

        private TaskWorkerRef() {
        }
    }

    private class FinishedTaskPoller
    implements Runnable {
        private boolean shutdown = false;
        private Thread pollingThread = null;

        private FinishedTaskPoller() {
        }

        public synchronized void shutdown() {
            this.shutdown = true;
            Thread thread = this.pollingThread;
            if (thread != null) {
                thread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.pollingThread = Thread.currentThread();
            boolean lastPollOk = true;
            while (!this.shutdown) {
                boolean removedJob;
                block18: {
                    int[] taskIds;
                    UUID[] jobIds;
                    Worker[] workers;
                    int nThreads;
                    Set set = ThreadServiceWorker.this.activeWorkers;
                    synchronized (set) {
                        Map map = ThreadServiceWorker.this.workerMap;
                        synchronized (map) {
                            nThreads = ThreadServiceWorker.this.activeWorkers.size();
                            int nJobs = ThreadServiceWorker.this.workerMap.size();
                            workers = new Worker[nThreads];
                            jobIds = new UUID[nThreads + nJobs];
                            taskIds = new int[nThreads + nJobs];
                            int i = 0;
                            Iterator<Object> i$ = ThreadServiceWorker.this.activeWorkers.iterator();
                            while (i$.hasNext()) {
                                Worker worker;
                                workers[i] = worker = (Worker)i$.next();
                                jobIds[i] = worker.getCurrentJobId();
                                taskIds[i++] = worker.getCurrentTaskId();
                            }
                            i$ = ThreadServiceWorker.this.workerMap.keySet().iterator();
                            while (i$.hasNext()) {
                                UUID jobId;
                                jobIds[i] = jobId = (UUID)i$.next();
                                taskIds[i++] = 0;
                            }
                        }
                    }
                    removedJob = false;
                    if (taskIds.length > 0) {
                        try {
                            BitSet finished = ThreadServiceWorker.this.service.getFinishedTasks(jobIds, taskIds);
                            lastPollOk = true;
                            int i = finished.nextSetBit(0);
                            while (i >= 0) {
                                if (i < nThreads) {
                                    workers[i].cancel(jobIds[i], taskIds[i]);
                                } else {
                                    ThreadServiceWorker.this.workerMap.remove(jobIds[i]);
                                    removedJob = true;
                                }
                                i = finished.nextSetBit(i + 1);
                            }
                        }
                        catch (Exception e) {
                            if (!lastPollOk) break block18;
                            logger.warn((Object)"Could not poll for finished tasks.", (Throwable)e);
                            lastPollOk = false;
                        }
                    }
                }
                if (removedJob) {
                    System.gc();
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {}
            }
            this.pollingThread = null;
        }
    }
}

